package cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.convert;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.resp.*;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Service
public class TuiaRespConvert {

    public AdxCommonBidResponse convert(BidResponse bidResponse) {
        if (bidResponse == null || bidResponse.getSeatBid() == null) {
            return null;
        }
        AdxCommonBidResponse response = new AdxCommonBidResponse();
        response.setRequestId(bidResponse.getId());
        response.setDspId(bidResponse.getDspId());
        List<CommonSeatBid> commonSeatBidList = new ArrayList<>();
        CommonSeatBid commonSeatBid = seatBidConvert(bidResponse.getSeatBid());
        commonSeatBidList.add(commonSeatBid);
        response.setCommonSeatBidList(commonSeatBidList);
        return response;
    }

    private CommonSeatBid seatBidConvert(SeatBid seatBid) {
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        CommonContext context = new CommonContext();
        commonSeatBid.setAdvertiserId("");
        commonSeatBid.setPrice(seatBid.getPrice() * 1.0);
        commonSeatBid.setPriceType(0);
        commonSeatBid.setWinCallbackUrls(seatBid.getWinUrls());
        commonSeatBid.setExposureCallbackUrls(seatBid.getExposureUrls());
        commonSeatBid.setClickCallbackUrls(seatBid.getClickUrls());
        commonSeatBid.setCommonContext(context);
        CommonCreative commonCreative = new CommonCreative();
        commonCreative.setAppName(seatBid.getAppName());
        commonCreative.setAppBundle(seatBid.getPackageName());
        commonCreative.setIconUrl(seatBid.getIconUrl());
        commonCreative.setMaterialId(seatBid.getCreativeId());
        CommonIcon commonIcon = new CommonIcon();
        commonIcon.setUrl(seatBid.getIconUrl());
        commonCreative.setCommonIcon(commonIcon);

        Adm adm = seatBid.getAdm();
        if (StringUtils.isNotBlank(adm.getTitle())) {
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle(adm.getTitle());
            commonCreative.setCommonTitle(commonTitle);
        }
        if (StringUtils.isNotBlank(adm.getDesc())) {
            CommonDesc commonDesc = new CommonDesc();
            commonDesc.setDesc(adm.getDesc());
            commonCreative.setCommonDesc(commonDesc);
        }
        if (adm.getVideo() != null) {
            VideoInfo video = adm.getVideo();
            CommonVideo commonVideo = new CommonVideo();
            commonVideo.setVideoUrl(video.getUrl());
            commonVideo.setResolutionX(video.getWidth());
            commonVideo.setResolutionY(video.getHeight());
            commonVideo.setDuration(BigDecimal.valueOf(video.getDuration()));
            commonVideo.setSize(video.getSize());
            commonVideo.setUnit("Byte");
            commonVideo.setCoverUrl(video.getCoverUrl());
            commonVideo.setCoverWidth(video.getWidth());
            commonVideo.setCoverHeight(video.getHeight());
            commonCreative.setCommonVideoList(Collections.singletonList(commonVideo));
        } else {
            ImageInfo image = adm.getImage();
            List<CommonImage> commonImages = new ArrayList<>();
            CommonImage commonImage = new CommonImage();
            commonImage.setUrl(image.getUrl());
            commonImage.setWidth(image.getWidth());
            commonImage.setHeight(image.getHeight());
            commonImages.add(commonImage);
            commonCreative.setCommonImageList(commonImages);
        }
        if (StringUtils.isNotBlank(adm.getDeepLink())) {
            commonCreative.setDeepLinkUrl(adm.getDeepLink());
            context.setDeepLinkUrl(adm.getDeepLink());
        }
        if (StringUtils.isNotBlank(adm.getUniversalLink())) {
            commonCreative.setULinkUrl(adm.getUniversalLink());
            context.setULinkUrl(adm.getUniversalLink());
        }
        commonCreative.setLandingPageUrl(adm.getLandingSite());
        commonSeatBid.setCommonCreative(commonCreative);

        return commonSeatBid;
    }
}
