package cn.com.duiba.tuia.dsp.engine.api.dsp.qihang.convert;

import cn.com.duiba.tuia.adx.center.api.common.Caid;
import cn.com.duiba.tuia.adx.center.api.dto.IdeaPriceStrategyDTO;
import cn.com.duiba.tuia.adx.center.api.dto.ResourceIdeaDto;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AppReplace;
import cn.com.duiba.tuia.dsp.engine.api.dsp.BidStatService;
import cn.com.duiba.tuia.dsp.engine.api.dsp.CalculateFloorPrice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.qihang.param.*;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Service
public class QiHangJsonReqConvert {
    @Autowired
    private AppReplace appReplace;
    @Autowired
    private BidStatService bidStatService;

    public QiHangRealReq convert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        QiHangRealReq qiHangRealReq = new QiHangRealReq();
        QiHangReq qiHangReq = new QiHangReq();
        qiHangReq.setId(adxCommonBidRequest.getRequestId());
        App app = appConvert(adxCommonBidRequest, dspInfo);
        qiHangReq.setApp(app);
        Device device = deviceConvert(adxCommonBidRequest, dspInfo);
        qiHangReq.setDevice(device);
        String tuiaDeviceId = adxCommonBidRequest.getDevice().getTuiaDeviceId();
        qiHangRealReq.setTuiaDeviceId(tuiaDeviceId);
        Imp imp = impConvert(adxCommonBidRequest, dspInfo);
        qiHangReq.setImp(imp);
        qiHangRealReq.setQiHangReq(qiHangReq);
        return qiHangRealReq;
    }

    private App appConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        App app = new App();
        CommonAppInfo appInfo = adxCommonBidRequest.getAppInfo();
        CommonAppInfo replaceApp = appReplace.getReplaceApp(dspInfo.getIdeaId());
        if (replaceApp != null) {
            app.setName(replaceApp.getName());
            app.setBundle(replaceApp.getBundle());
        } else {
            if (appInfo.getName() != null) {
                app.setName(appInfo.getName());
            }
            app.setBundle(appInfo.getBundle());
        }

        if (appInfo.getVersion() != null) {
            app.setVersion(appInfo.getVersion());
        }
        return app;
    }

    private Device deviceConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        Device builder = new Device();
        CommonDevice device = adxCommonBidRequest.getDevice();
        builder.setUa(device.getUa());
        builder.setIp(device.getIp());
        Integer deviceType = device.getDeviceType();
        builder.setDevice_type(4);
        if (deviceType != null && deviceType == 2) {
            builder.setDevice_type(3);
        }
        builder.setMake(device.getMake());
        builder.setModel(device.getModel());
        if (device.getOaId() != null) {
            builder.setOaid(device.getOaId());
        }
        if (device.getOaIdMd5() != null) {
            builder.setOaid_md5(device.getOaIdMd5());
        }
        if (device.getImei() != null) {
            builder.setImei(device.getImei());
        }
        if (device.getImeiMd5() != null) {
            builder.setImei_md5(device.getImeiMd5());
        }
        if (device.getIdFaMd5() != null) {
            builder.setIdfa_md5(device.getIdFaMd5());
        }
        if (device.getIdFa() != null) {
            builder.setIdfa(device.getIdFa());
        }
        if (device.getDpId() != null) {
            builder.setAndroid_id(device.getDpId());
        }
        if (device.getDpIdMd5() != null) {
            builder.setAndroid_id_md5(device.getDpIdMd5());
        }
        if (device.getBootTime() != null) {
            builder.setBoot_mark(device.getBootTime());
        }
        if (device.getUpdateTime() != null) {
            builder.setUpdate_mark(device.getUpdateTime());
        }
        if (device.getOs() != null) {
            if ("1".equals(device.getOs())) {
                builder.setOs("ios");
            } else {
                builder.setOs("android");
            }
        }
        if (device.getOsVersion() != null) {
            builder.setOsv(device.getOsVersion());
        }
        builder.setCarrier(0);
        builder.setConnection_type(0);
        if (device.getTuiaConnectionType() != null) {
            builder.setConnection_type(device.getTuiaConnectionType());
        }
        List<Caid> caids = device.getCaids();
        //只要20220111版本的caid
        List<CaidInfo> caidInfos = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(caids)) {
            for (Caid caid : caids) {
                if (StringUtils.isNotBlank(caid.getId())) {
                    CaidInfo caidInfo = new CaidInfo();
                    caidInfo.setCaid(caid.getId());
                    caidInfo.setVersion(caid.getVersion());
                    caidInfos.add(caidInfo);
                }
            }
        }
        builder.setCaid_infos(caidInfos);
        return builder;
    }

    private Imp impConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        Imp imp = new Imp();
        CommonImp commonImp = adxCommonBidRequest.getImpList().get(0);
        imp.setId(commonImp.getId());
        imp.setTag_id(dspInfo.getDspTagId());
        imp.setSub_tag_id(dspInfo.getIdeaId() + BlowfishUtils.encryptBlowfish(adxCommonBidRequest.getAppInfo().getBundle(), "abc"));
        //1:信息流
        //2:开屏
        //3：banner
        //4：插屏
        //9：激励视频
        imp.setAd_type(Integer.parseInt(dspInfo.getDspResId()));
        imp.setBid_type(0);
        ResourceIdeaDto resourceIdeaDto = bidStatService.getResourceIdeaByCache(String.valueOf(dspInfo.getIdeaId()));
        //判断是否cpc计费
        if ((resourceIdeaDto != null && resourceIdeaDto.getPriceType() == 2) || dspInfo.getCpcCharge() == 1) {
            imp.setBid_type(1);
            long floorPrice = CalculateFloorPrice.getFloorPrice(commonImp.getCpcFloorPrice(), dspInfo);
            if (floorPrice == 0) {
                floorPrice = 10;
            }
            imp.setCpc_bid_floor((int) floorPrice);
        } else {
            long floorPrice = CalculateFloorPrice.getFloorPrice(commonImp.getFloorPrice(), dspInfo);
            imp.setBid_floor((int) floorPrice);
        }
        List<Integer> adStyles = new ArrayList<>();
        adStyles.add(1);
        adStyles.add(3);
        if (commonImp.isOpenQuickApp()) {
            adStyles.add(6);
        }

        imp.setAd_styles(adStyles);
        Asset asset = new Asset();
        asset.setTemplate_id(dspInfo.getDspTemplateId());
        CommonSizeInfo commonSizeInfo = commonImp.getFilteringSize().get(0);
        asset.setWidth(commonSizeInfo.getWidth());
        asset.setHeight(commonSizeInfo.getHeight());
        List<Asset> assetList = new ArrayList<>();
        assetList.add(asset);
        imp.setAsset(assetList);
        return imp;
    }
}
