package cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.bean;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;

@Data
public class Device {

    //手机系统 1:android 2:ios
    private Integer os;
    //客户端的真实ipv4
    private String ip;
    //客户端的真实ipv6
    private String ip_v6;
    //浏览器的系统UA
    private String userAgent;
    //设备系统版本号
    private String osVersion;
    //设备网络类型
    //设备网络类型 ：
    //UNKNOWN => 未知;
    //NET_2G => 2G网;
    //NET_3G => 3G网;
    //NET_4G => 4G网;
    //NET_5G => 5G网;
    //WIFI => 无线网
    private String network;
    //手机生产厂商(品牌)
    private String vendor;
    //经度
    private Float longitude;
    //纬度
    private Float latitude;
    //屏幕像素宽度, 以竖屏为准
    private Integer screenWidth;
    //屏幕每英寸像素数目, eg:300, 256
    private Integer ppi;
    //屏幕尺寸, eg:6.1, 6.2
    private Float inch;
    //设备类型。
    //PHONE:手机
    //PAD:平板
    //OTHER:其他
    private String deviceType;
    //屏幕方向
    //PORTRAIT:竖屏
    //LANDSCAPE:横屏
    private String orientation;
    //安卓api版本
    private Integer androidApiLevel;
    //mac地址
    private String mac;
    //原始mac(不做大小写转换)的md5值, MD5后的小写形式
    private String macMd5;
    //android id 原值 ， 16个字符，仅限安卓设备
    private String androidId;
    //原始androidId(不做大小写转换)的md5值, MD5后的小写形式
    private String md5AndroidId;
    //android oaid 原值，部分厂商部分安卓系统版本提供，MSA官方链接为：http://msa-alliance.cn/ ；
    //仅限安卓设备
    private String oaid;
    //原始oaid(不做大小写转换)的md5值, MD5后的小写形式
    private String md5Oaid;
    //imei号， 可获取时建议填写
    private String imei;
    //原始imei(不做大小写转换)的md5值, MD5后的小写形式
    private String md5Imei;
    //caid标识符,
    //仅限iOS设备
    private String caid;
    //caid版本号,
    //仅限iOS设备
    private String caidVer;
    //iOS idfa 原值 ；
    //仅限iOS设备
    private String idfa;
    //原始idfa(不做大小写转换)的md5值, MD5后的小写形式
    private String md5Idfa;
    //iOS idfv 原值 ；
    //仅限iOS设备
    private String idfv;
    //手机型号，示例
    //iOS："iPhone10,3"
    //安卓："PCNM00"
    private String modelNo;
    //系统最近一次开机时间, 秒级时间戳,（保留整数）
    //示例："1595214620" ；
    //仅限iOS设备
    private Long osBootTime;
    //系统最近一次更新时间, 秒级时间戳,（保留整数）
    private Long osUpdateTime;
    //设备名称
    private String phoneName;
    //手机容量大小, 单位byte
    private Long diskSize;
    //手机内存大小, 单位byte
    private Long memorySize;
    //设备model值
    private String hardwareModel;
    //国际移动用户识别码, eg. 46001
    private String imsi;
    //国家
    private String country;
    //语言, eg. 'zh-Hans-CN' ；
    private String language;
    //时区, eg. GMT+8, GMT+08:00；
    private String timeZone;
    //官方商店版本号(oppo, vivo, 华为),
    private String storeVersion;
    //华为hms core 版本
    private String hmsVersion;
    // 鸿蒙系统内核版本
    private String harmonyOsVer;
    // 小米MIUI版本, 或者华为UI版本号
    private String osUiVersion;
    // 客户端已经安装的应用包名列表
    private String[] installApps;
    // 是否支持微信小程序广告下发
    private Boolean supportWechat;
    // 开发者匿名设备标识符, 安卓
    private String vaid;
    // 剩余电量, eg. 60
    private Integer batteryPower;
    // 电池状态； UNKNOWN:未知 UNPLUGGED:不充电 CHARGING:充电中
    private String batteryStatus;
    // CPU个数
    private Integer cpuNumber;
    // CPU频率, 单位GHz
    private Float cpuFrequency;
    // 系统启动标识 安卓示例: "ec7f4f33-411a-47bc-8067-744a4e7e0723" iOS示例: "1623815045.970028"
    private String osBootMark;
    // 系统更新标识 安卓示例: "1004697.709999999" iOS示例: "1581141691.570419583"
    private String osUpdateMark;
    // Android系统开机使用时间, 秒级时间戳
    private Long osElapseTime;
    // ios, 设备初始化时间, 案例:1647545718.125795458
    private String deviceBirthTime;
    //拼多多广告ID;
    //生成规则:MD5(osBootTime + ":" + osUpdateTime), eg. de1611ebbe675ba71731c71ff7bf13ad
    private String paId;

    public void setDeviceType(String deviceType) {
        if (isNotBlank(deviceType)) {
            this.deviceType = deviceType;
        }
    }

    public void setMac(String mac) {
        if (isNotBlank(mac)) {
            this.mac = mac;
        }

    }

    public void setMacMd5(String macMd5) {
        if (isNotBlank(macMd5)) {
            this.macMd5 = macMd5;
        }
    }

    public void setAndroidId(String androidId) {
        if (isNotBlank(androidId)) {
            this.androidId = androidId;
        }
    }

    public void setMd5AndroidId(String md5AndroidId) {
        if (isNotBlank(md5AndroidId)) {
            this.md5AndroidId = md5AndroidId;
        }
    }

    public void setOaid(String oaid) {
        if (isNotBlank(oaid)) {
            this.oaid = oaid;
        }
    }

    public void setMd5Oaid(String md5Oaid) {
        if (isNotBlank(md5Oaid)) {
            this.md5Oaid = md5Oaid;
        }
    }

    public void setImei(String imei) {
        if (isNotBlank(imei)) {
            this.imei = imei;
        }
    }

    public void setMd5Imei(String md5Imei) {
        if (isNotBlank(md5Imei)) {
            this.md5Imei = md5Imei;
        }
    }

    public void setCaid(String caid) {
        if (isNotBlank(caid)) {
            this.caid = caid;
        }
    }

    public void setCaidVer(String caidVer) {
        if (isNotBlank(caidVer)) {
            this.caidVer = caidVer;
        }
    }

    public void setIdfa(String idfa) {
        if (isNotBlank(idfa)) {
            this.idfa = idfa;
        }
    }

    public void setMd5Idfa(String md5Idfa) {
        if (isNotBlank(md5Idfa)) {
            this.md5Idfa = md5Idfa;
        }
    }

    public void setIdfv(String idfv) {
        if (isNotBlank(idfv)) {
            this.idfv = idfv;
        }
    }

    public void setPaId(String paId) {
        if (isNotBlank(paId)) {
            this.paId = paId;
        }
    }

    private static boolean isNotBlank(String value) {
        return StringUtils.isNotBlank(value);
    }
}
