package cn.com.duiba.tuia.dsp.engine.api.dsp.fancy;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.spring.boot.starter.dsp.util.CatUtils;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.fancy.bean.BidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.fancy.bean.BidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.fancy.convert.FancyReqConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.fancy.convert.FancyRespConvert;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import com.dianping.cat.Cat;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.*;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;

@Component
@Slf4j
public class FancyDspInvoker extends AbstractDspCaller<BidResponse, BidRequest> {

    @Autowired
    private FancyReqConvert fancyReqConvert;

    @Autowired
    private FancyRespConvert fancyRespConvert;

    @Autowired
    private FancyDspProperties fancyDspProperties;

    @Resource(name = "dspRestTemplate")
    private RestTemplate restTemplate;


    @Override
    protected BidResponse invokeDsp(BidRequest bidRequest) {
        if (bidRequest == null) {
            return null;
        }
        Cat.logMetricForCount("泛为DSP调用");
        try {
            return CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(fancyDspProperties.getUrl(), bidRequest), "invokeDSP", "fancy");
        } catch (Throwable t) {
            Cat.logMetricForCount("泛为_竞价失败");
            if (!(t instanceof RestClientException || t instanceof SocketTimeoutException)) {
                log.warn("泛为调用异常", t);
            }
        }
        return null;
    }

    private BidResponse doHttpInvoke(String url, BidRequest bidRequest) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json;charset=UTF-8");
        headers.add("Connection", "Keep-Alive");
        HttpEntity<BidRequest> request = new HttpEntity<>(bidRequest, headers);
        ResponseEntity<BidResponse> responseEntity = null;
        try {
            responseEntity = restTemplate.exchange(url, HttpMethod.POST, request, BidResponse.class);
        } catch (Exception e) {
            if (!(e instanceof RestClientException)) {
                log.warn("泛为调用异常 response is {}", responseEntity, e);
            }
            return null;
        }
        if (responseEntity.getStatusCode().equals(HttpStatus.NO_CONTENT)) {
            return null;
        }
        SamplerLog.info("泛为 response is {}", responseEntity.getBody());
        Cat.logMetricForCount("泛为DSP返回");
        return responseEntity.getBody();
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        return price.toString();
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_17.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_17;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        return url.replace("${AUCTION_PRICE}", price);
    }

    @Override
    public BidRequest convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        return fancyReqConvert.convert(adxCommonBidRequest, dspInfo);
    }

    @Override
    public AdxCommonBidResponse convertResp(BidResponse bidResponse) throws DspException {
        if (bidResponse != null && bidResponse.getSeatbid() != null) {
            return fancyRespConvert.convert(bidResponse);
        }
        return null;
    }
}
