package cn.com.duiba.tuia.dsp.engine.api.dsp.ruishi.convert;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruishi.bean.*;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Component
public class RuiShiRespConvert {

    public AdxCommonBidResponse convert(RuiShiRsp ruiShiRsp) {
        Bid bid = ruiShiRsp.getBid();
        if (bid == null) {
            return null;
        }
        AdxCommonBidResponse commonBidResponse = new AdxCommonBidResponse();
        commonBidResponse.setRequestId(ruiShiRsp.getId());
        commonBidResponse.setDspId(DspEnum.DSP_11.getDspId());
        CommonSeatBid commonSeatBid = bidConvert(bid);
        List<CommonSeatBid> commonSeatBidList = new ArrayList<>();
        commonSeatBidList.add(commonSeatBid);
        commonBidResponse.setCommonSeatBidList(commonSeatBidList);
        return commonBidResponse;
    }

    private CommonSeatBid bidConvert(Bid bid) {
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        CommonContext context = new CommonContext();

        commonSeatBid.setPrice((double) bid.getPrice());
        commonSeatBid.setExposureCallbackUrls(bid.getImptrackers());
        commonSeatBid.setClickCallbackUrls(bid.getClicktrackers());
        commonSeatBid.setCommonContext(context);

        CommonCreative commonCreative = new CommonCreative();
        String iconUrl = null;
        if (bid.getBrand_name() != null) {
            commonCreative.setAppName(bid.getBrand_name());
        }
        if (bid.getPkgname() != null) {
            commonCreative.setAppBundle(bid.getPkgname());
        }
        if (bid.getBrand_logo() != null) {
            iconUrl = bid.getBrand_logo();
        }
        if (iconUrl != null) {
            CommonIcon commonIcon = new CommonIcon();
            commonIcon.setUrl(iconUrl);
            commonCreative.setCommonIcon(commonIcon);
        }
        if (bid.getTitle() != null) {
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle(bid.getTitle());
            commonCreative.setCommonTitle(commonTitle);
        }
        if (bid.getDesc() != null) {
            CommonDesc commonDesc = new CommonDesc();
            commonDesc.setDesc(bid.getDesc());
            commonCreative.setCommonDesc(commonDesc);
        }
        if (bid.getVideo() != null) {
            Video video = bid.getVideo();
            CommonVideo commonVideo = new CommonVideo();
            commonVideo.setVideoUrl(video.getVurl());
            commonVideo.setResolutionX(video.getVw());
            commonVideo.setResolutionY(video.getVh());
            commonVideo.setDuration(BigDecimal.valueOf(video.getDuration()));
            commonVideo.setSize(video.getVsize());
            commonVideo.setUnit("Byte");
            List<Image> image = bid.getImage();
            if (CollectionUtils.isNotEmpty(image)) {
                Image coverImg = image.get(0);
                commonVideo.setCoverUrl(coverImg.getUrl());
                commonVideo.setCoverWidth(coverImg.getWidth());
                commonVideo.setCoverHeight(coverImg.getHeight());
            }
            commonCreative.setCommonVideoList(Collections.singletonList(commonVideo));
        } else {
            List<Image> imageList = bid.getImage();
            List<CommonImage> commonImages = new ArrayList<>(imageList.size());
            for (Image image : imageList) {
                CommonImage commonImage = new CommonImage();
                commonImage.setUrl(image.getUrl());
                commonImage.setWidth(image.getWidth());
                commonImage.setHeight(image.getHeight());
                commonImages.add(commonImage);
            }
            commonCreative.setCommonImageList(commonImages);
        }
        if (StringUtils.isNotBlank(bid.getDeeplink())) {
            commonCreative.setDeepLinkUrl(bid.getDeeplink());
            context.setDeepLinkUrl(bid.getDeeplink());
        }
        if (StringUtils.isNotBlank(bid.getUlk_scheme())) {
            commonCreative.setULinkUrl(bid.getUlk_scheme());
            context.setULinkUrl(bid.getUlk_scheme());
        }

        commonCreative.setLandingPageUrl(bid.getLdp());
        commonSeatBid.setCommonCreative(commonCreative);
        return commonSeatBid;
    }
}
