package cn.com.duiba.tuia.dsp.engine.api.dsp.baidu;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.baidu.convert.BaiDuDspReqConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.baidu.convert.BaiDuDspRespConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.baidu.proto.BaiDuDsp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import com.google.protobuf.InvalidProtocolBufferException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

@Slf4j
@Component
public class BaiDuDspInvoker extends AbstractDspCaller<BaiDuDsp.Response, BaiDuDsp.Request> {
    @Autowired
    private BaiDuDspReqConvert baiDuDspReqConvert;
    @Autowired
    private BaiDuDspRespConvert baiDuDspRespConvert;
    @Autowired
    private BaiDuDspProperties baiDuDspProperties;
    @Resource(name = "dspRestTemplate")
    private RestTemplate restTemplate;

    //application/x-protobuf;charset=UTF-8

    @Override
    protected BaiDuDsp.Response invokeDsp(BaiDuDsp.Request request) {
        if (request == null) {
            return null;
        }
        Cat.logMetricForCount("百度DSP调用");
        try {
            return CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(baiDuDspProperties.getBaiduDspUrl(), request), "invokeDSP", "baiduDsp");
        } catch (Throwable t) {
            Cat.logMetricForCount("百度dsp_竞价失败");
            if (!(t instanceof RestClientException || t instanceof SocketTimeoutException)) {
                SamplerLog.warn("百度dsp调用异常", t);
            }
        }
        return null;
    }

    private BaiDuDsp.Response doHttpInvoke(String url, BaiDuDsp.Request request) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/x-protobuf;charset=UTF-8");
        HttpEntity<byte[]> entity = new HttpEntity<>(request.toByteArray(), headers);
        ResponseEntity<byte[]> responseEntity = null;
        try {
            responseEntity = restTemplate.exchange(url, HttpMethod.POST, entity, byte[].class);
        } catch (Exception e) {
            if (!(e instanceof RestClientException)) {
                SamplerLog.warn("百度dsp调用异常", e);
            }
            return null;
        }
        byte[] body = responseEntity.getBody();
        if (body == null) {
            return null;
        }
        try {
            BaiDuDsp.Response response = BaiDuDsp.Response.parseFrom(body);
            if (CollectionUtils.isEmpty(response.getSeatbidList())) {
                return null;
            }
            Cat.logMetricForCount("百度DSP返回");
            return response;
        } catch (Exception e) {
            log.warn("百度dsp调用异常 ", e);
        }
        return null;
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(Cipher.ENCRYPT_MODE, new SecretKeySpec(baiDuDspProperties.getSecret().getBytes(StandardCharsets.UTF_8), "AES"));

            byte[] encryptedData = cipher.doFinal(price.toString().getBytes(StandardCharsets.UTF_8));
            return Base64.getUrlEncoder().encodeToString(encryptedData);
        } catch (Exception e) {
            log.warn("priceEncryption error", e);
        }
        return "";
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_27.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_27;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (StringUtils.isNotBlank(price)) {
            return url.replaceAll("__WIN_PRICE_SECURE__", price);
        }
        return url;
    }

    @Override
    public BaiDuDsp.Request convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        return baiDuDspReqConvert.convertReq(adxCommonBidRequest, dspInfo);
    }

    @Override
    public AdxCommonBidResponse convertResp(BaiDuDsp.Response response) throws DspException {
        if (response == null || CollectionUtils.isEmpty(response.getSeatbidList())) {
            return null;
        }
        return baiDuDspRespConvert.convert(response);
    }
}
