/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.youku.convert;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonContext;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonCreative;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonDesc;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonIcon;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonImage;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonSeatBid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonTitle;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonVideo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.youku.param.Ad;
import cn.com.duiba.tuia.dsp.engine.api.dsp.youku.param.Apk;
import cn.com.duiba.tuia.dsp.engine.api.dsp.youku.param.Bid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.youku.param.BidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.youku.param.Image;
import cn.com.duiba.tuia.dsp.engine.api.dsp.youku.param.Video;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class RespConvert {
    public AdxCommonBidResponse convert(BidResponse bidResponse) {
        AdxCommonBidResponse response = new AdxCommonBidResponse();
        response.setRequestId(bidResponse.getId());
        response.setDspId(DspEnum.DSP_18.getDspId());
        ArrayList<CommonSeatBid> commonSeatBidList = new ArrayList<CommonSeatBid>();
        CommonSeatBid commonSeatBid = this.seatBidConvert(bidResponse.getBid().get(0));
        commonSeatBidList.add(commonSeatBid);
        response.setCommonSeatBidList(commonSeatBidList);
        return response;
    }

    private CommonSeatBid seatBidConvert(Bid bid) {
        Ad ad = bid.getAd().get(0);
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        CommonContext context = new CommonContext();
        commonSeatBid.setPrice((double)ad.getPrice() * 1.0);
        commonSeatBid.setPriceType(0);
        commonSeatBid.setWinCallbackUrls(ad.getWnm());
        commonSeatBid.setExposureCallbackUrls(ad.getPm());
        commonSeatBid.setClickCallbackUrls(ad.getCm());
        commonSeatBid.setCommonContext(context);
        CommonCreative commonCreative = new CommonCreative();
        commonCreative.setMaterialId(ad.getCrid());
        if (ad.getApk() != null) {
            Apk apk = ad.getApk();
            commonCreative.setAppName(apk.getApp_name());
        }
        if (ad.getLogo() != null) {
            commonCreative.setIconUrl(ad.getLogo().getUrl());
            CommonIcon commonIcon = new CommonIcon();
            commonIcon.setUrl(ad.getLogo().getUrl());
            commonCreative.setCommonIcon(commonIcon);
        }
        if (StringUtils.isNotBlank((CharSequence)ad.getTitle())) {
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle(ad.getTitle());
            commonCreative.setCommonTitle(commonTitle);
        }
        if (StringUtils.isNotBlank((CharSequence)ad.getSub_title())) {
            CommonDesc commonDesc = new CommonDesc();
            commonDesc.setDesc(ad.getSub_title());
            commonCreative.setCommonDesc(commonDesc);
        }
        if (ad.getVideo() != null) {
            Video video = ad.getVideo();
            CommonVideo commonVideo = new CommonVideo();
            commonVideo.setVideoUrl(video.getUrl());
            commonVideo.setResolutionX(video.getWidth());
            commonVideo.setResolutionY(video.getHeight());
            if (video.getDuration() != null) {
                commonVideo.setDuration(BigDecimal.valueOf(video.getDuration().intValue()));
            }
            commonVideo.setSize(video.getSize());
            commonVideo.setUnit("Byte");
            commonVideo.setCoverUrl(video.getCover_image_url());
            commonVideo.setCoverWidth(video.getWidth());
            commonVideo.setCoverHeight(video.getHeight());
            commonCreative.setCommonVideoList(Collections.singletonList(commonVideo));
        } else {
            Image image2 = ad.getImage();
            CommonImage commonImage = new CommonImage();
            commonImage.setUrl(image2.getUrl());
            commonImage.setWidth(image2.getWidth());
            commonImage.setHeight(image2.getHeight());
            commonCreative.setCommonImageList(Collections.singletonList(commonImage));
        }
        commonCreative.setLandingPageUrl(ad.getLdp());
        if (StringUtils.isNotBlank((CharSequence)ad.getDp())) {
            commonCreative.setDeepLinkUrl(ad.getDp());
            context.setDeepLinkUrl(ad.getDp());
        }
        if (StringUtils.isNotBlank((CharSequence)ad.getULink())) {
            commonCreative.setULinkUrl(ad.getULink());
            context.setULinkUrl(ad.getULink());
        }
        commonSeatBid.setCommonCreative(commonCreative);
        return commonSeatBid;
    }
}

