package cn.com.duiba.tuia.dsp.engine.api.dsp.kuaishou.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.kuaishou.bean.KuaishouBidRequestOuterClass;
import org.apache.commons.lang3.StringUtils;

/**
 * @Author kuaishou
 * @Date 2022/10/9
 * @Description
 * @Param
 * @return
 **/
public class CarrierConverter {
    //移动
    public static final String MOVE = "1";
    //联通
    public static final String UNICOM = "2";
    //电信
    public static final String TELECOM = "3";

    public static KuaishouBidRequestOuterClass.KuaishouBidRequest.Carrier getCarrierType(String carrier) {
        if (StringUtils.isBlank(carrier)) {
            return KuaishouBidRequestOuterClass.KuaishouBidRequest.Carrier.CARRIER_CHINAMOBILE;
        }
        switch (carrier) {
            case MOVE:
                return KuaishouBidRequestOuterClass.KuaishouBidRequest.Carrier.CARRIER_CHINAMOBILE;
            case UNICOM:
                return KuaishouBidRequestOuterClass.KuaishouBidRequest.Carrier.CARRIER_CHINAUNICOM;
            case TELECOM:
                return KuaishouBidRequestOuterClass.KuaishouBidRequest.Carrier.CARRIER_CHINATELECOM;
            default:
                return KuaishouBidRequestOuterClass.KuaishouBidRequest.Carrier.CARRIER_UNKNOWN;
        }
    }
}
