/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.meituan.conver;

import cn.com.duiba.tuia.adx.center.api.common.Caid;
import cn.com.duiba.tuia.adx.center.api.dto.ResourceIdeaDto;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AppReplace;
import cn.com.duiba.tuia.dsp.engine.api.dsp.BidStatService;
import cn.com.duiba.tuia.dsp.engine.api.dsp.CalculateFloorPrice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonAppInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonDevice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonGeo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonImp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonSizeInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.meituan.param.MeituanRTB;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MeituanReqConvert {
    @Autowired
    private AppReplace appReplace;
    @Autowired
    private BidStatService bidStatService;

    public MeituanRTB.RtbRequest convert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        MeituanRTB.RtbRequest.Builder builder = MeituanRTB.RtbRequest.newBuilder();
        builder.setRequestId(adxCommonBidRequest.getRequestId());
        builder.setAdxName("tuia");
        MeituanRTB.Device.Builder device = this.convertDevice(adxCommonBidRequest, dspInfo);
        if (device == null) {
            return null;
        }
        builder.setDevice(device);
        MeituanRTB.LocationInfo.Builder location = this.convertLocation(adxCommonBidRequest, dspInfo);
        builder.setLocation(location);
        MeituanRTB.AdSlot.Builder adslot = this.convertAdslot(adxCommonBidRequest, dspInfo);
        builder.addAdslots(adslot);
        MeituanRTB.App.Builder app = this.convertApp(adxCommonBidRequest, dspInfo);
        builder.setApp(app);
        builder.setToken("5GQKxC6L0Cli/g6y");
        return builder.build();
    }

    private MeituanRTB.App.Builder convertApp(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        MeituanRTB.App.Builder app = MeituanRTB.App.newBuilder();
        CommonAppInfo appInfo = adxCommonBidRequest.getAppInfo();
        CommonAppInfo replaceApp = this.appReplace.getReplaceApp(dspInfo.getIdeaId());
        if (replaceApp != null) {
            app.setAppName(replaceApp.getName());
            app.setPackageName(replaceApp.getBundle());
        } else {
            if (appInfo.getName() != null) {
                app.setAppName(appInfo.getName());
            }
            app.setPackageName(appInfo.getBundle());
        }
        return app;
    }

    private MeituanRTB.AdSlot.Builder convertAdslot(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        MeituanRTB.AdSlot.Builder adSlot = MeituanRTB.AdSlot.newBuilder();
        CommonImp commonImp = adxCommonBidRequest.getImpList().get(0);
        String slotId = adxCommonBidRequest.getAdxType() == 29 || adxCommonBidRequest.getAdxType() == 48 || adxCommonBidRequest.getAdxType() >= 68 ? BlowfishUtils.encryptBlowfish((String)adxCommonBidRequest.getAppInfo().getBundle(), (String)"abc") : BlowfishUtils.encryptBlowfish((String)commonImp.getExternalAdBlockId(), (String)"abc");
        adSlot.setAdslotId(dspInfo.getIdeaId() + slotId);
        MeituanRTB.TemplateInfo.Builder template = MeituanRTB.TemplateInfo.newBuilder();
        template.setTemplateId(dspInfo.getDspTemplateId());
        CommonSizeInfo commonSizeInfo = commonImp.getFilteringSize().get(0);
        if (commonSizeInfo.getType() == 3) {
            MeituanRTB.Video.Builder video = MeituanRTB.Video.newBuilder();
            video.addVideoTypes(MeituanRTB.VideoType.VT_UNKNOWN);
            if (commonSizeInfo.getMinduration() != null) {
                video.setMinduration(commonSizeInfo.getMinduration());
            }
            if (commonSizeInfo.getMaxduration() != null) {
                video.setMaxduration(commonSizeInfo.getMaxduration());
            }
            template.setVideo(video);
        }
        adSlot.addTemplates(template);
        adSlot.setIsHttps(commonImp.isLinkAgreement());
        ResourceIdeaDto resourceIdeaDto = this.bidStatService.getResourceIdeaByCache(String.valueOf(dspInfo.getIdeaId()));
        if (resourceIdeaDto != null && resourceIdeaDto.getPriceType() == 2 || dspInfo.getCpcCharge() == 1) {
            adSlot.addPriceTypes(MeituanRTB.PriceType.CPC_PRICE);
            long floorPrice = CalculateFloorPrice.getFloorPrice(commonImp.getCpcFloorPrice(), dspInfo);
            adSlot.setCpcFloor(floorPrice * 1000L);
        } else {
            long floorPrice = CalculateFloorPrice.getFloorPrice(commonImp.getFloorPrice(), dspInfo);
            adSlot.setFloor(floorPrice);
            adSlot.addPriceTypes(MeituanRTB.PriceType.CPM_PRICE);
        }
        return adSlot;
    }

    private MeituanRTB.LocationInfo.Builder convertLocation(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        String ip;
        CommonDevice device = adxCommonBidRequest.getDevice();
        CommonGeo geo = device.getGeo();
        MeituanRTB.LocationInfo.Builder location = MeituanRTB.LocationInfo.newBuilder();
        if (geo != null) {
            location.setLatitude(geo.getLat());
            location.setLongitude(geo.getLon());
        }
        if ((ip = device.getIp()).contains(":")) {
            location.setIpv6(ip);
        } else {
            location.setIpv4(ip);
        }
        location.setLatLonType(MeituanRTB.LatLonType.WGS84);
        return location;
    }

    private MeituanRTB.Device.Builder convertDevice(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        String os;
        MeituanRTB.DeviceId.Builder deviceId;
        MeituanRTB.Device.Builder device = MeituanRTB.Device.newBuilder();
        CommonDevice commonDevice = adxCommonBidRequest.getDevice();
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getImei())) {
            deviceId = MeituanRTB.DeviceId.newBuilder();
            deviceId.setId(commonDevice.getImei());
            deviceId.setDeviceIdType(MeituanRTB.DeviceIdType.IMEI);
            deviceId.setEncryptionType(MeituanRTB.EncryptionType.PLAINTEXT);
            device.addDeviceIds(deviceId);
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getImeiMd5())) {
            deviceId = MeituanRTB.DeviceId.newBuilder();
            deviceId.setId(commonDevice.getImeiMd5());
            deviceId.setDeviceIdType(MeituanRTB.DeviceIdType.IMEI);
            deviceId.setEncryptionType(MeituanRTB.EncryptionType.MD5);
            device.addDeviceIds(deviceId);
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getIdFa())) {
            deviceId = MeituanRTB.DeviceId.newBuilder();
            deviceId.setId(commonDevice.getIdFa());
            deviceId.setDeviceIdType(MeituanRTB.DeviceIdType.IDFA);
            deviceId.setEncryptionType(MeituanRTB.EncryptionType.PLAINTEXT);
            device.addDeviceIds(deviceId);
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getIdFaMd5())) {
            deviceId = MeituanRTB.DeviceId.newBuilder();
            deviceId.setId(commonDevice.getIdFaMd5());
            deviceId.setDeviceIdType(MeituanRTB.DeviceIdType.IDFA);
            deviceId.setEncryptionType(MeituanRTB.EncryptionType.MD5);
            device.addDeviceIds(deviceId);
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getOaId())) {
            deviceId = MeituanRTB.DeviceId.newBuilder();
            deviceId.setId(commonDevice.getOaId());
            deviceId.setDeviceIdType(MeituanRTB.DeviceIdType.OAID);
            deviceId.setEncryptionType(MeituanRTB.EncryptionType.PLAINTEXT);
            device.addDeviceIds(deviceId);
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getOaIdMd5())) {
            deviceId = MeituanRTB.DeviceId.newBuilder();
            deviceId.setId(commonDevice.getOaIdMd5());
            deviceId.setDeviceIdType(MeituanRTB.DeviceIdType.OAID);
            deviceId.setEncryptionType(MeituanRTB.EncryptionType.MD5);
            device.addDeviceIds(deviceId);
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getDpId())) {
            deviceId = MeituanRTB.DeviceId.newBuilder();
            deviceId.setId(commonDevice.getDpId());
            deviceId.setDeviceIdType(MeituanRTB.DeviceIdType.ANDROID_ID);
            deviceId.setEncryptionType(MeituanRTB.EncryptionType.PLAINTEXT);
            device.addDeviceIds(deviceId);
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getDpIdMd5())) {
            deviceId = MeituanRTB.DeviceId.newBuilder();
            deviceId.setId(commonDevice.getDpIdMd5());
            deviceId.setDeviceIdType(MeituanRTB.DeviceIdType.ANDROID_ID);
            deviceId.setEncryptionType(MeituanRTB.EncryptionType.MD5);
            device.addDeviceIds(deviceId);
        }
        if (CollectionUtils.isNotEmpty(commonDevice.getCaids())) {
            Caid caid = commonDevice.getCaids().get(0);
            MeituanRTB.DeviceId.Builder deviceId2 = MeituanRTB.DeviceId.newBuilder();
            deviceId2.setId(caid.getId());
            deviceId2.setDeviceIdType(MeituanRTB.DeviceIdType.CAID);
            deviceId2.setEncryptionType(MeituanRTB.EncryptionType.PLAINTEXT);
            device.addDeviceIds(deviceId2);
        }
        if ((os = commonDevice.getOs()) == null) {
            return null;
        }
        if ("1".equals(commonDevice.getOs())) {
            device.setPlateformType(MeituanRTB.DevicePlatformType.DPT_IOS);
        } else if ("0".equals(commonDevice.getOs())) {
            device.setPlateformType(MeituanRTB.DevicePlatformType.DPT_ANDROID);
        } else {
            device.setPlateformType(MeituanRTB.DevicePlatformType.DPT_UNKNOWN);
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getCarrier())) {
            String carrier = commonDevice.getCarrier();
            if ("1".equals(carrier)) {
                device.setOperatiorType(MeituanRTB.DeviceOperatorType.DOT_MOBILE);
            } else if ("2".equals(carrier)) {
                device.setOperatiorType(MeituanRTB.DeviceOperatorType.DOT_UNICOM);
            } else if ("3".equals(carrier)) {
                device.setOperatiorType(MeituanRTB.DeviceOperatorType.DOT_TELECOM);
            } else {
                device.setOperatiorType(MeituanRTB.DeviceOperatorType.DOT_UNKNOWN);
            }
        }
        if (commonDevice.getTuiaConnectionType() != null) {
            Integer connectionType = commonDevice.getTuiaConnectionType();
            if (connectionType == 2) {
                device.setNetworkType(MeituanRTB.NetworkType.NETWORK_WIFI);
            } else if (connectionType == 4) {
                device.setNetworkType(MeituanRTB.NetworkType.NETWORK_2G);
            } else if (connectionType == 5) {
                device.setNetworkType(MeituanRTB.NetworkType.NETWORK_3G);
            } else if (connectionType == 6) {
                device.setNetworkType(MeituanRTB.NetworkType.NETWORK_4G);
            } else if (connectionType == 7) {
                device.setNetworkType(MeituanRTB.NetworkType.NETWORK_5G);
            } else {
                device.setNetworkType(MeituanRTB.NetworkType.NETWORK_UNKNOWN);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getMake())) {
            device.setBrand(commonDevice.getMake());
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getModel())) {
            device.setModel(commonDevice.getModel());
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getOsVersion())) {
            device.setOsVersion(commonDevice.getOsVersion());
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getUa())) {
            device.setUa(commonDevice.getUa());
        }
        return device;
    }
}

