package cn.com.duiba.tuia.dsp.engine.api.dsp.pdd;


import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.constants.PddNbr;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.converter.PddReqConverter;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.converter.PddRespConverter;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duiba.tuia.dsp.engine.api.util.CloseableHttpClientUtil;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dianping.cat.Cat;
import com.github.luben.zstd.Zstd;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.http.*;
import org.springframework.stereotype.Component;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Objects;

import static cn.com.duiba.tuia.dsp.engine.api.exception.DspErrorCode.*;

/**
 * @author Wangpf
 * @date 2022/7/1 10:14 上
 */
@Component
@EnableConfigurationProperties(PddProperties.class)
public class PddDspInvoker extends AbstractDspCaller<PddResponse, PddRequest> {

    private static final Logger LOGGER = LoggerFactory.getLogger(PddDspInvoker.class);

    @Resource
    PddReqConverter pddConverter;
    @Resource
    PddRespConverter pddRespConverter;

    @Resource(name = "dspRestTemplate")
    @CanAccessInsideNetwork
    private RestTemplate restTemplate;

    @Resource
    private CloseableHttpClientUtil httpClientUtil;

    @Resource
    private PddProperties pddProperties;


    @Override
    public PddRequest convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        try {
            return pddConverter.reqConvert(adxCommonBidRequest, dspInfo);
        } catch (Exception e) {
            throw new DspException(REQ_PARAM_CONVERT_ERROR, e);
        }

    }

    @Override
    protected PddResponse invokeDsp(PddRequest pddRequest) {
        if (pddRequest == null) {
            return null;
        }
        if (pddRequest.getImp() == null || pddRequest.getImp().isEmpty()) {
            return null;
        }
        Cat.logMetricForCount("拼多多DSP调用");
        try {
            return CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(pddProperties.getUrl(), pddRequest), "invokeDSP", "pdd");
        } catch (ResourceAccessException e) {
            throw new DspException(DSP_HTTP_INVOKE_FAILED, this.getDsp(), e);
        } catch (Exception e) {
            throw new DspException(DSP_INVOKE_FAILED, this.getDsp(), e);
        } catch (Throwable e) {
            LOGGER.error("拼多多其他调用异常", e);
            return null;
        }
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(Cipher.ENCRYPT_MODE, new SecretKeySpec(pddProperties.getAdxSecret().getBytes(), "AES"));
            return new String(Base64.getEncoder().encode(cipher.doFinal(price.toString().getBytes())));
        } catch (NoSuchAlgorithmException | NoSuchPaddingException | InvalidKeyException | IllegalBlockSizeException |
                 BadPaddingException e) {
            LOGGER.warn("{} 拼多多价格加密失败,secret:{}", pddProperties.getAdxId(), pddProperties.getAdxSecret(), e);
            return null;
        }
    }

    /**
     * 发起http请求
     *
     * @param url
     */
    private PddResponse doHttpInvoke(String url, PddRequest pddRequest) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
//        headers.add("Content-Encoding", "zstd");
//        byte[] compressData = Zstd.compress(JSON.toJSONBytes(pddRequest));
        HttpEntity<PddRequest> requestEntity = new HttpEntity<>(pddRequest, headers);
        ResponseEntity<PddResponse> resEntity = null;
        HttpStatus statusCode = null;
        PddResponse body = null;
        try {
            resEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity, PddResponse.class);
            statusCode = resEntity.getStatusCode();
            body = resEntity.getBody();

        } catch (Exception e) {
            if (!(e instanceof RestClientException)) {
                LOGGER.warn("拼多多调用异常 response is {}", resEntity, e);
            }
        }
        if (body == null) {
            return null;
        }
//        int frameContentSize = (int) Zstd.getFrameContentSize(body);
//        if (frameContentSize < 0) {
//            LOGGER.warn("拼多多返回数据解析失败,body:{}", JSONObject.toJSONString(body));
//            return null;
//        }
//        byte[] array = new byte[frameContentSize];
//        Zstd.decompress(array, body);
//        String bodyString = new String(array, StandardCharsets.UTF_8);
//        PddResponse response = JSONObject.parseObject(bodyString,PddResponse.class);
        if (statusCode.is2xxSuccessful()) {
            if (HttpStatus.OK.value() == statusCode.value()) {
                return this.handle2xx(body);
            } else {
                if (SamplerLog.infoFlag()) {
                    SamplerLog.info("拼多多DSP无内容返回,pddRequest[{}],body[{}]", JSONObject.toJSONString(pddRequest), JSONObject.toJSONString(body));
                }
                return null;
            }
        } else if (statusCode.is5xxServerError()) {
            LOGGER.warn("拼多多DSP返回5xx,pddRequest[{}],body[{}]", JSONObject.toJSONString(pddRequest), JSONObject.toJSONString(body));
            return null;
        } else {
            LOGGER.warn("拼多多DSP返回其他状态码,pddRequest[{}],body[{}]", JSONObject.toJSONString(pddRequest), JSONObject.toJSONString(body));
            return null;
        }

    }

    private PddResponse handle2xx(PddResponse pddResponse) {
        if (!pddResponse.getNbr().equals(0) && SamplerLog.infoFlag()) {
            SamplerLog.info("拼多多DSP返回为空:{}", JSONObject.toJSONString(pddResponse));
        }
        Integer val;
        if (Objects.isNull(val = pddResponse.getNbr())) {
            return null;
        }
        if (PddNbr.NBR_0.getNbr().equals(val)) {
            Cat.logMetricForCount("拼多多DSP返回");
        }
        return pddResponse;
    }

    @Override
    public AdxCommonBidResponse convertResp(PddResponse pddResponse) throws DspException {
        try {
            return pddRespConverter.respConvert(pddResponse);
        } catch (Exception e) {
            throw new DspException(RESP_PARAM_CONVERT_ERROR, this.getDsp(), e);
        }
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_3.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_3;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("%%PRICE%%") && price != null) {
            url = url.replace("%%PRICE%%", price);
        }
        return url;
    }

    @Override
    public void doWinCallBack(String url) {
        httpClientUtil.doGet(url);
    }

    @Override
    public void doClickCallBack(String url) {
        httpClientUtil.doGet(url);
    }

    @Override
    public void doExposureCallBack(String url) {
        httpClientUtil.doGet(url);
    }
}
