package cn.com.duiba.tuia.dsp.engine.api.dsp.huichuan.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.huichuan.resp.HuichuanResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.bean.RgyunBiddingResponse;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import com.google.common.collect.Lists;
import com.google.protobuf.ProtocolStringList;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.*;

/**
 * @Author yuquanfeng
 * @Date 2022/9/30
 * @Description
 * @Param
 * @return
 **/
@Component
public class HuichuanResponseConverter {

    public AdxCommonBidResponse respConvert(HuichuanResponse rtbResponse) {
        if (Objects.isNull(rtbResponse)) {
            return null;
        }
        AdxCommonBidResponse adxCommonBidResponse = new AdxCommonBidResponse();
        adxCommonBidResponse.setDspId(DspEnum.DSP_20.getDspId());
        adxCommonBidResponse.setRequestId(rtbResponse.getSid());
        List<CommonSeatBid> commonSeatBids = seatConvert(rtbResponse);
        adxCommonBidResponse.setCommonSeatBidList(commonSeatBids);
        return adxCommonBidResponse;
    }

    private List<CommonSeatBid> seatConvert(HuichuanResponse rtbResponse) {
        List<CommonSeatBid> commonSeatBidList = Lists.newArrayList();
        // 遍历所有广告位
        for (HuichuanResponse.SlotAd slotAd : rtbResponse.getSlot_ad()) {
            // 遍历广告位中的广告
            for (HuichuanResponse.Ad ad : slotAd.getAd()) {
                CommonSeatBid commonSeatBid = new CommonSeatBid();

                // 设置基础信息（与工程中其他DSP保持相同结构）
                commonSeatBid.setAdvertiserId("44910"); // 固定值与其他DSP对齐
                HuichuanResponse.AdContent adContent = ad.getAd_content();

                // 构建创意信息
                CommonCreative commonCreative = new CommonCreative();
                HuichuanResponse.AdContent content = ad.getAd_content();
                if (content != null) {

                    commonSeatBid.setPriceType(0);
                    commonSeatBid.setPrice(Double.valueOf(adContent.getDsp_bid_price()));
                    // 标题处理
                    CommonTitle commonTitle = new CommonTitle();
                    commonTitle.setTitle(content.getTitle());
                    commonCreative.setCommonTitle(commonTitle);

                    commonCreative.setPrivacyPolicyLink(content.getPrivacy());
                    commonCreative.setPermissionLink(content.getPermission());
                    commonCreative.setAppName(content.getApp_name());
                    commonCreative.setAppBundle(content.getPackage_name());
                    commonCreative.setIconUrl(content.getApp_logo());
                    commonCreative.setDeveloper(content.getDeveloper());
                    commonCreative.setDownloadUrl(content.getDownload_url());
                    commonCreative.setAppFeature(content.getFunction_desc());
                    commonCreative.setULinkUrl(adContent.getAdm_fixed_ulk());

                    // 添加上下文信息
                    CommonContext context = new CommonContext();
                    context.setULinkUrl(adContent.getAdm_fixed_ulk());
                    commonSeatBid.setCommonContext(context);

                    if (StringUtils.isNotBlank(content.getV_1_video_aliyun())) {
                        CommonVideo commonVideo = new CommonVideo();
                        commonVideo.setVideoUrl(content.getV_1_video_aliyun());
                        commonVideo.setDuration(new BigDecimal(Integer.parseInt(content.getV_1_video_duration())));
                        commonVideo.setSize(Integer.parseInt(content.getV_1_video_size()));
                        commonCreative.setCommonVideoList(Collections.singletonList(commonVideo));
                    }

                    // 图片处理
                    if (StringUtils.isNotBlank(content.getImg_1())) {
                        CommonImage commonImage = new CommonImage();
                        commonImage.setUrl(content.getImg_1());
                        commonImage.setWidth(Integer.parseInt(content.getImg_1_w()));
                        commonImage.setHeight(Integer.parseInt(content.getImg_1_h()));
                        commonCreative.setCommonImageList(Collections.singletonList(commonImage));
                    }

                    // Logo处理
                    if (StringUtils.isNotBlank(content.getLogo_url())) {
                        CommonIcon commonIcon = new CommonIcon();
                        commonIcon.setUrl(content.getLogo_url());
                        commonCreative.setCommonIcon(commonIcon);
                    }
                }
                commonCreative.setLandingPageUrl(CollectionUtils.isEmpty(ad.getTurl()) ? null : ad.getTurl().get(0));
                commonSeatBid.setCommonCreative(commonCreative);

                // 设置回调URL（根据demo中的字段映射）
                commonSeatBid.setWinCallbackUrls(Collections.singletonList(ad.getWnurl()));
                commonSeatBid.setExposureCallbackUrls(ad.getVurl());
                commonSeatBid.setClickCallbackUrls(ad.getCurl());



                commonSeatBidList.add(commonSeatBid);
            }
        }

        return commonSeatBidList;
    }


}
