package cn.com.duiba.tuia.dsp.engine.api.dsp.firefly.convert;

import cn.com.duiba.tuia.dsp.engine.api.dsp.AppReplace;
import cn.com.duiba.tuia.dsp.engine.api.dsp.CalculateFloorPrice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.firefly.bean.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;

@Service
public class FireflyReqConvert {
    @Autowired
    private AppReplace appReplace;

    public FireFlyReq convert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        FireFlyReq fireFlyReq = new FireFlyReq();
        fireFlyReq.setReqId(adxCommonBidRequest.getRequestId());
        List<AdSlot> adSlots = adslotConvert(adxCommonBidRequest, dspInfo);
        fireFlyReq.setAdSlots(adSlots);
        App App = appConvert(adxCommonBidRequest.getAppInfo(), dspInfo);
        fireFlyReq.setApp(App);
        Device device = deviceConvert(adxCommonBidRequest);
        fireFlyReq.setDevice(device);
        UserLocation userLocation = userLocationConvert(adxCommonBidRequest);
        fireFlyReq.setUserLocation(userLocation);
        return fireFlyReq;
    }

    private UserLocation userLocationConvert(AdxCommonBidRequest adxCommonBidRequest) {
        CommonDevice commonDevice = adxCommonBidRequest.getDevice();
        UserLocation userLocation = new UserLocation();
        if (commonDevice == null) {
            return userLocation;
        }
        if (commonDevice.getGeo() == null) {
            return userLocation;
        }
        CommonGeo geo = commonDevice.getGeo();
        if (geo.getLat() != null && geo.getLon() != null) {
            userLocation.setLat(geo.getLat().floatValue());
            userLocation.setLon(geo.getLon().floatValue());
            userLocation.setType("WGS-84");
        }
        return userLocation;
    }

    private Device deviceConvert(AdxCommonBidRequest adxCommonBidRequest) {
        CommonDevice commonDevice = adxCommonBidRequest.getDevice();
        Device device = new Device();
        String ip = commonDevice.getIp();
        if (ip.contains(":")) {
            device.setIpv6(ip);
        } else {
            device.setIp(ip);
        }
        device.setUa(commonDevice.getUa());
        String carrier = commonDevice.getCarrier();
        if ("1".equals(carrier)) {
            device.setCarrier(Carrier.Mobile.getCode());
        } else if ("2".equals(carrier)) {
            device.setCarrier(Carrier.Unicom.getCode());
        } else if ("3".equals(carrier)) {
            device.setCarrier(Carrier.Telecom.getCode());
        } else {
            device.setCarrier(Carrier.Unknown.getCode());
        }
        Integer connectionType = commonDevice.getTuiaConnectionType();
        if (connectionType == null) {
            device.setNetworkType(NetworkType.UNKNOWN_NETWORK.getCode());
        } else if (connectionType == 2) {
            device.setNetworkType(NetworkType.WIFI.getCode());
        } else if (connectionType == 4) {
            device.setNetworkType(NetworkType.MOBILE_2G.getCode());
        } else if (connectionType == 5) {
            device.setNetworkType(NetworkType.MOBILE_3G.getCode());
        } else if (connectionType == 6) {
            device.setNetworkType(NetworkType.MOBILE_4G.getCode());
        } else if (connectionType == 7) {
            device.setNetworkType(NetworkType.MOBILE_5G.getCode());
        } else {
            device.setNetworkType(NetworkType.UNKNOWN_NETWORK.getCode());
        }
        device.setDeviceType(1);
        if ("1".equals(commonDevice.getOs())) {
            device.setOs(OS.IOS.getCode());
        } else if ("0".equals(commonDevice.getOs())) {
            device.setOs(OS.ANDROID.getCode());
        } else {
            device.setOs(OS.UNKNOWN_OS.getCode());
        }
        device.setOsv(commonDevice.getOsVersion());
        device.setMake(commonDevice.getMake());
        device.setModel(commonDevice.getModel());
        Uid uid = new Uid();
        uid.setDpid(commonDevice.getDpId());
        uid.setDpidMd5(commonDevice.getDpIdMd5());
        uid.setOaid(commonDevice.getOaId());
        uid.setOaidMd5(commonDevice.getOaIdMd5());
        device.setUid(uid);

        return device;
    }

    private App appConvert(CommonAppInfo appInfo, DspInfo dspInfo) {
        App app = new App();
        CommonAppInfo replaceApp = appReplace.getReplaceApp(dspInfo.getIdeaId());
        if (replaceApp != null) {
            app.setBundle(replaceApp.getBundle());
        } else {
            app.setBundle(appInfo.getBundle());
        }
        app.setAppType(2);
        return app;
    }

    private List<AdSlot> adslotConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        CommonImp commonImp = adxCommonBidRequest.getImpList().get(0);
        List<AdSlot> adSlots = new ArrayList<>();
        AdSlot adSlot = new AdSlot();
        CommonAppInfo appInfo = adxCommonBidRequest.getAppInfo();
        adSlot.setAppId(appInfo.getBundle());
        adSlot.setThirdAdSlotId(dspInfo.getDspTagId());
        long floorPrice = CalculateFloorPrice.getFloorPrice(commonImp.getFloorPrice(), dspInfo);
        adSlot.setBidFloor((int) floorPrice);
        adSlot.setAdType(Integer.parseInt(dspInfo.getDspResId()));
        Asset asset = new Asset();
        List<Asset> assets = new ArrayList<>();
        CommonSizeInfo commonSizeInfo = commonImp.getFilteringSize().get(0);
        int width = commonSizeInfo.getWidth();
        int height = commonSizeInfo.getHeight();
        BigDecimal divide = new BigDecimal(width).divide(new BigDecimal(height), 2, RoundingMode.HALF_UP);
        if (divide.doubleValue() == 1.52) {
            //38:25
            asset.setRatio(AspectRatio.RATIO_38x25.getCode());
        } else if (divide.doubleValue() == 0.56) {
            //9:16
            asset.setRatio(AspectRatio.RATIO_9X16.getCode());
        } else if (divide.doubleValue() == 1.78) {
            //16:9
            asset.setRatio(AspectRatio.RATIO_16X9.getCode());
        }
        assets.add(asset);
        adSlot.setAssets(assets);
        List<Integer> actionType = new ArrayList<>();
        actionType.add(1);
        actionType.add(2);
        adSlot.setActionType(actionType);
        adSlot.setMaxCount(1);
        adSlot.setMaterialType(MaterialType.AdMaterialTypeImg.getCode());
        if (commonSizeInfo.getType() == 3) {
            VideoInfo videoInfo = new VideoInfo();
            videoInfo.setW(commonSizeInfo.getWidth());
            videoInfo.setH(commonSizeInfo.getHeight());
            if (commonSizeInfo.getMaxduration() != null) {
                videoInfo.setDuration(commonSizeInfo.getMaxduration());
            }
            adSlot.setVideo(videoInfo);
            adSlot.setMaterialType(MaterialType.AdMaterialTypeVideo.getCode());
        }
        adSlots.add(adSlot);
        return adSlots;
    }
}
