/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.converter;

import cn.com.duiba.tuia.adx.center.api.common.Caid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AppReplace;
import cn.com.duiba.tuia.dsp.engine.api.dsp.CalculateFloorPrice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonAppInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonDevice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonGeo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonImp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonUserInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddDspInvoker;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req.App;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req.CaidInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req.Device;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req.Geo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req.Imp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req.Template;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req.User;
import cn.com.duiba.tuia.pangea.center.api.localservice.apollopangu.ApolloPanGuService;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PddReqConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PddDspInvoker.class);
    @Resource
    PddProperties dspPddProperties;
    @Autowired
    private ApolloPanGuService apolloPanGuService;
    @Autowired
    private AppReplace appReplace;
    List<String> tagIds = Collections.singletonList("1");

    public PddRequest reqConvert(AdxCommonBidRequest commonReq, DspInfo dspInfo) {
        PddRequest pddRequest = new PddRequest();
        pddRequest.setAdx_id(this.dspPddProperties.getAdxId());
        pddRequest.setRequest_id(commonReq.getRequestId());
        pddRequest.setAt(Objects.isNull(commonReq.getAt()) ? 2 : commonReq.getAt());
        List<CommonImp> impList = commonReq.getImpList();
        App app = this.appConvert(commonReq.getAppInfo(), dspInfo);
        pddRequest.setApp(app);
        List<Imp> imps = impList.stream().map(imp -> this.impConvert((CommonImp)imp, dspInfo)).collect(Collectors.toList());
        if (imps.isEmpty() || imps.size() == 1 && imps.contains(null)) {
            return null;
        }
        pddRequest.setImp(imps);
        pddRequest.setDevice(this.deviceConvert(commonReq.getDevice()));
        pddRequest.setUser(this.userConvert(commonReq.getUserInfo()));
        return pddRequest;
    }

    private User userConvert(CommonUserInfo userInfo) {
        User user = new User();
        user.setTag_id(this.tagIds);
        if (userInfo == null) {
            return user;
        }
        user.setId(userInfo.getId());
        user.setGender(userInfo.getGender());
        Optional.ofNullable(userInfo.getYob()).ifPresent(yop -> user.setAge(String.valueOf(LocalDate.now().getYear() - yop)));
        return user;
    }

    private Device deviceConvert(CommonDevice commonDevice) {
        Device device = new Device();
        if (Objects.isNull(commonDevice)) {
            return device;
        }
        device.setUa(commonDevice.getUa());
        if (commonDevice.getIp().contains(":")) {
            device.setIpv6(commonDevice.getIp());
        } else {
            device.setIp(commonDevice.getIp());
        }
        device.setDevicetype(1);
        if (Objects.equals(commonDevice.getDeviceType(), 2)) {
            device.setDevicetype(2);
        }
        device.setMake(commonDevice.getMake());
        device.setModel(commonDevice.getModel());
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getOs())) {
            if ("0".equals(commonDevice.getOs())) {
                device.setOs("android");
            }
            if ("1".equals(commonDevice.getOs())) {
                device.setOs("ios");
            }
        }
        device.setOsv(commonDevice.getOsVersion());
        String connectionType = commonDevice.getConnectionType();
        if ("1".equals(connectionType)) {
            device.setConnectiontype(1);
        } else if ("2".equals(connectionType)) {
            device.setConnectiontype(2);
        } else if ("3".equals(connectionType)) {
            device.setConnectiontype(3);
        } else if ("4".equals(connectionType)) {
            device.setConnectiontype(4);
        } else if ("5".equals(connectionType)) {
            device.setConnectiontype(5);
        } else if ("6".equals(connectionType)) {
            device.setConnectiontype(6);
        } else if ("7".equals(connectionType)) {
            device.setConnectiontype(7);
        } else {
            device.setConnectiontype(0);
        }
        String carrier = commonDevice.getCarrier();
        if ("1".equals(carrier)) {
            device.setCarrier("mobile");
        } else if ("2".equals(carrier)) {
            device.setCarrier("unicom");
        } else if ("3".equals(carrier)) {
            device.setCarrier("telecom");
        } else {
            device.setCarrier("unknown");
        }
        device.setImei(commonDevice.getImei());
        device.setImei_md5(commonDevice.getImeiMd5());
        device.setAndroidid(commonDevice.getDpId());
        device.setAndroidid_md5(commonDevice.getDpIdMd5());
        device.setIdfa(commonDevice.getIdFa());
        device.setIdfa_md5(commonDevice.getIdFaMd5());
        device.setOaid(commonDevice.getOaId());
        device.setOaid_md5(commonDevice.getOaIdMd5());
        if (CollectionUtils.isNotEmpty(commonDevice.getCaids())) {
            ArrayList<CaidInfo> caidInfos = new ArrayList<CaidInfo>();
            for (Caid caid : commonDevice.getCaids()) {
                CaidInfo caidInfo = new CaidInfo();
                caidInfo.setCaid(caid.getId());
                caidInfo.setVersion_str(caid.getVersion());
                caidInfos.add(caidInfo);
            }
            device.setCaid_infos(caidInfos);
        }
        device.setPaid(commonDevice.getPaid());
        device.setPaid_1_4(commonDevice.getPaid_1_4());
        device.setPnid(commonDevice.getPnid());
        device.setBirth_time(commonDevice.getBirthTime());
        device.setBoot_time(commonDevice.getBootTime());
        device.setUpdate_time(commonDevice.getUpdateTime());
        if (commonDevice.getGeo() != null) {
            device.setGeo(this.geoConvert(commonDevice.getGeo()));
        }
        return device;
    }

    private Geo geoConvert(CommonGeo commonGeo) {
        Geo geo = new Geo();
        Optional.ofNullable(commonGeo.getLat()).ifPresent(lat -> geo.setLatitude(Float.valueOf(lat.floatValue())));
        Optional.ofNullable(commonGeo.getLon()).ifPresent(leo -> geo.setLongitude(Float.valueOf(leo.floatValue())));
        return geo;
    }

    private App appConvert(CommonAppInfo appInfo, DspInfo dspInfo) {
        App app = new App();
        if (Objects.isNull(appInfo)) {
            return app;
        }
        CommonAppInfo replaceApp = this.appReplace.getReplaceApp(dspInfo.getIdeaId());
        if (replaceApp != null) {
            app.setName(replaceApp.getName());
            app.setBundle(replaceApp.getBundle());
        } else {
            app.setName(appInfo.getName());
            app.setBundle(appInfo.getBundle());
        }
        app.setVersion(appInfo.getVersion());
        return app;
    }

    public Imp impConvert(CommonImp commonImp, DspInfo dspInfo) {
        Imp imp = new Imp();
        if (Objects.isNull(commonImp)) {
            return null;
        }
        ArrayList<Template> templates = new ArrayList<Template>();
        if (StringUtils.isBlank((CharSequence)dspInfo.getDspTemplateId()) || StringUtils.isBlank((CharSequence)dspInfo.getDspTagId())) {
            LOGGER.warn("\u8ba1\u5212\u672a\u914d\u7f6edsp\u76f8\u5173\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e \u8ba1\u5212id {}", (Object)dspInfo.getIdeaId());
            return null;
        }
        imp.setTagid(dspInfo.getDspTagId());
        templates.add(new Template(dspInfo.getDspTemplateId()));
        imp.setTemplates(templates);
        imp.setId(commonImp.getId());
        long floorPrice = CalculateFloorPrice.getFloorPrice(commonImp.getCpcFloorPrice(), dspInfo);
        imp.setBidfloor((int)floorPrice);
        imp.setContent_type(Arrays.asList(1, 2));
        imp.setClick_strategy(1);
        imp.setSupport_deeplink(true);
        imp.setQuick_app_flow(0);
        return imp;
    }
}

