package cn.com.duiba.tuia.dsp.engine.api.dsp.tiangong;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tiangong.bean.TgSsp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tiangong.convert.TianGongReqConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tiangong.convert.TianGongRespConvert;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

@Component
@Slf4j
public class TianGongDspInvoker extends AbstractDspCaller<TgSsp.Response, TgSsp.Request> {
    @Autowired
    private TianGongReqConvert reqConvert;
    @Autowired
    private TianGongRespConvert respConvert;
    @Autowired
    private TianGongProperties tianGongProperties;
    @Resource(name = "dspRestTemplate")
    private RestTemplate restTemplate;


    @Override
    protected TgSsp.Response invokeDsp(TgSsp.Request request) {
        if (request == null) {
            return null;
        }
        Cat.logMetricForCount("天宫DSP调用");
        try {
            return CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(tianGongProperties.getUrl(), request), "invokeDSP", "tiangong");
        } catch (Throwable t) {
            Cat.logMetricForCount("启航_竞价失败");
            if (!(t instanceof RestClientException || t instanceof SocketTimeoutException)) {
                SamplerLog.warn("启航调用异常", t);
            }
        }
        return null;
    }

    private TgSsp.Response doHttpInvoke(String url, TgSsp.Request request) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/octet-stream");
        headers.add("Content-Encoding", "gzip");
        headers.add("Accept-Encoding","gzip");
        //使用gzip压缩
        byte[] requestBytes = gzipCompress(request.toByteArray());
        if (requestBytes == null) {
            return null;
        }
        HttpEntity<byte[]> httpEntity = new HttpEntity<>(requestBytes, headers);
        ResponseEntity<byte[]> exchange = null;
        try {
            exchange = restTemplate.exchange(url, HttpMethod.POST, httpEntity, byte[].class);
        } catch (Exception e) {
            if (!(e instanceof RestClientException)) {
                log.warn("天宫调用异常", e);
            }
            return null;
        }
        byte[] body = exchange.getBody();
        if (body != null) {
            byte[] decompress = gzipDecompress(body);
            if (decompress != null) {
                TgSsp.Response response;
                try {
                    response = TgSsp.Response.parseFrom(decompress);
                } catch (Exception e) {
                    //
                    return null;
                }
                return response;
            }
        }


        return null;
    }

    //gzip压缩
    private byte[] gzipCompress(byte[] data) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(); GZIPOutputStream gzipOS = new GZIPOutputStream(bos)) {
            gzipOS.write(data);
            gzipOS.finish();
            return bos.toByteArray();
        } catch (IOException e) {
            log.warn("gzip压缩失败", e);
        }
        return null;
    }

    //gzip解压
    private byte[] gzipDecompress(byte[] data) {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(data); GZIPInputStream gis = new GZIPInputStream(bis); ByteArrayOutputStream bos = new ByteArrayOutputStream()) {
            byte[] buffer = new byte[4096];
            int len;
            // 4. 循环读取解压后的数据，写入输出流
            while ((len = gis.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
            // 5. 将缓存的解压数据转为字节数组返回
            return bos.toByteArray();
        } catch (IOException e) {
            log.warn("gzip解压失败", e);
        }
        return null;
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        return "";
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_20.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_20;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        return url;
    }

    @Override
    public TgSsp.Request convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        return reqConvert.convert(adxCommonBidRequest, dspInfo);
    }

    @Override
    public AdxCommonBidResponse convertResp(TgSsp.Response response) throws DspException {
        if (response == null || response.getStatus() != 0) {
            return null;
        }
        return respConvert.convert(response);
    }
}
