package cn.com.duiba.tuia.dsp.engine.api.filter;

import cn.com.duiba.tuia.adx.center.api.dto.ResourceIdeaDto;
import cn.com.duiba.tuia.dsp.engine.api.dsp.BidStatService;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonSeatBid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuickAppFilter {
    @Autowired
    private BidStatService bidStatService;

    public AdxCommonBidResponse filter(AdxCommonBidResponse adxCommonBidResponse, DspInfo dspInfo) {
        ResourceIdeaDto resourceIdeaByCache = bidStatService.getResourceIdeaByCache(String.valueOf(dspInfo.getIdeaId()));
        if (resourceIdeaByCache == null) {
            return null;
        }
        //为1 过滤
        if (resourceIdeaByCache.getQuickAppState().equals(1)) {
            CommonSeatBid commonSeatBid = adxCommonBidResponse.getCommonSeatBidList().get(0);
            if (commonSeatBid != null && commonSeatBid.getCommonContext() != null) {
                String deepLinkUrl = commonSeatBid.getCommonContext().getDeepLinkUrl();
                if (!StringUtils.isBlank(deepLinkUrl)) {
                    if (deepLinkUrl.startsWith("hap") || deepLinkUrl.startsWith("hwfastapp")) {
                        //过滤掉当前响应
                        return null;
                    }
                }
            }
        }
        return adxCommonBidResponse;
    }
}
