/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.guangtui.converter;

import cn.com.duiba.tuia.adx.center.api.common.Caid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AppReplace;
import cn.com.duiba.tuia.dsp.engine.api.dsp.CalculateFloorPrice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonAppInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonDevice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonGeo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonImp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonSizeInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonUserInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.guangtui.GuangtuiProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.guangtui.bean.Guangtui;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GunagtuiRequestConverter {
    private static final Logger log = LoggerFactory.getLogger(GunagtuiRequestConverter.class);
    @Autowired
    private AppReplace appReplace;
    @Resource
    private GuangtuiProperties guangtuiProperties;

    public Guangtui.Request reqConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        Guangtui.Request.Builder adRequestBuilder = Guangtui.Request.newBuilder();
        adRequestBuilder.setId(adxCommonBidRequest.getRequestId());
        adRequestBuilder.setToken(this.guangtuiProperties.getToken());
        Guangtui.Imp imp = this.convertImp(adxCommonBidRequest, dspInfo);
        adRequestBuilder.addImp(imp);
        adRequestBuilder.setApp(this.convertApp(adxCommonBidRequest, dspInfo));
        Guangtui.Device deviceInfo = this.convertDevice(adxCommonBidRequest);
        adRequestBuilder.setDevice(deviceInfo);
        Guangtui.User adUserInfo = this.convertUserInfo(adxCommonBidRequest);
        adRequestBuilder.setUser(adUserInfo);
        return adRequestBuilder.build();
    }

    private Guangtui.App convertApp(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        Guangtui.App.Builder adAppInfo = Guangtui.App.newBuilder();
        CommonAppInfo appInfo = adxCommonBidRequest.getAppInfo();
        CommonAppInfo replaceApp = this.appReplace.getReplaceApp(dspInfo.getIdeaId());
        if (replaceApp != null) {
            adAppInfo.setName(replaceApp.getName()).setBundle(replaceApp.getBundle()).setVer(replaceApp.getVersion());
        } else {
            if (appInfo.getName() != null) {
                adAppInfo.setName(appInfo.getName());
            }
            if (appInfo.getBundle() != null) {
                adAppInfo.setBundle(appInfo.getBundle());
            }
            if (appInfo.getVersion() != null) {
                adAppInfo.setVer(appInfo.getVersion());
            }
        }
        return adAppInfo.build();
    }

    private Guangtui.Device convertDevice(AdxCommonBidRequest adxCommonBidRequest) {
        Guangtui.Device.Builder adDeviceInfo = Guangtui.Device.newBuilder();
        CommonDevice device = adxCommonBidRequest.getDevice();
        adDeviceInfo.setOs(this.convertOs(device.getOs()));
        if (device.getOsVersion() != null) {
            adDeviceInfo.setOsv(device.getOsVersion());
        }
        if (device.getImei() != null) {
            adDeviceInfo.setDid(device.getImei());
        }
        if (device.getImeiMd5() != null) {
            adDeviceInfo.setDidmd5(device.getImeiMd5());
        }
        if (device.getOaId() != null) {
            adDeviceInfo.setOid(device.getOaId());
        }
        if (device.getOaIdMd5() != null) {
            adDeviceInfo.setOidmd5(device.getOaIdMd5());
        }
        if (device.getDpId() != null) {
            adDeviceInfo.setDpid(device.getDpId());
        }
        if (device.getDpIdMd5() != null) {
            adDeviceInfo.setDpidmd5(device.getDpIdMd5());
        }
        if (device.getIdFa() != null) {
            adDeviceInfo.setIfa(device.getIdFa());
        }
        if (device.getIdfv() != null) {
            adDeviceInfo.setIdfv(device.getIdfv());
        }
        if (device.getIdFaMd5() != null) {
            adDeviceInfo.setIdfvMd5(device.getIdFaMd5());
        }
        if (device.getIp() != null) {
            adDeviceInfo.setIp(device.getIp());
        }
        if (device.getUa() != null) {
            adDeviceInfo.setUa(device.getUa());
        }
        if (device.getTuiaConnectionType() != null) {
            adDeviceInfo.setConnectiontype(device.getTuiaConnectionType());
        }
        adDeviceInfo.setCarrier(this.convertCarrier(device.getCarrier()));
        if (device.getMake() != null) {
            adDeviceInfo.setMake(device.getMake());
        }
        if (device.getModel() != null) {
            adDeviceInfo.setModel(device.getModel());
        }
        if (device.getMac() != null) {
            adDeviceInfo.setMac(device.getMac());
        }
        if (device.getMacMd5() != null) {
            adDeviceInfo.setMacmd5(device.getMacMd5());
        }
        Guangtui.Geo.Builder geoBuilder = Guangtui.Geo.newBuilder();
        CommonGeo geo = device.getGeo();
        if (geo != null) {
            geoBuilder.setLat((geo.getLat() != null ? Float.valueOf(geo.getLat().floatValue()) : null).floatValue()).setLon((geo.getLon() != null ? Float.valueOf(geo.getLon().floatValue()) : null).floatValue()).setGeoType(geo.getType());
            if (geo.getCountry() != null) {
                adDeviceInfo.setCountry(geo.getCountry());
            }
            adDeviceInfo.setGeo(geoBuilder.build());
        }
        if (device.getUpdateTime() != null) {
            adDeviceInfo.setUpdateTime(device.getUpdateTime());
        }
        if (device.getBootTime() != null) {
            adDeviceInfo.setBootTime(device.getBootTime());
        }
        if (device.getBirthTime() != null) {
            adDeviceInfo.setBirthTime(device.getBirthTime());
        }
        if (device.getPaid_1_4() != null) {
            adDeviceInfo.setPaid14(device.getPaid_1_4());
        }
        adDeviceInfo.setCaid(this.getCaidJson(device.getCaids()));
        return adDeviceInfo.build();
    }

    private Guangtui.User convertUserInfo(AdxCommonBidRequest adxCommonBidRequest) {
        Guangtui.User.Builder adUserInfo = Guangtui.User.newBuilder();
        CommonUserInfo commonUserInfo = adxCommonBidRequest.getUserInfo();
        if (commonUserInfo != null) {
            if (commonUserInfo.getGender() != null) {
                adUserInfo.setGender(commonUserInfo.getGender());
            }
            if (commonUserInfo.getKeywords() != null) {
                adUserInfo.setKeywords(commonUserInfo.getKeywords());
            }
        }
        return adUserInfo.build();
    }

    private String getCaidJson(List<Caid> caids) {
        if (CollectionUtils.isEmpty(caids)) {
            return "";
        }
        JSONArray caidArr = new JSONArray();
        for (Caid caid : caids) {
            JSONObject caidJson = new JSONObject();
            caidJson.put("version", (Object)caid.getVersion());
            caidJson.put("caid", (Object)caid.getId());
            caidArr.add((Object)caidJson);
        }
        return caidArr.toJSONString();
    }

    private int convertCarrier(String carrier) {
        try {
            return Integer.parseInt(carrier);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private int convertOs(String os) {
        if (StringUtils.isBlank((CharSequence)os)) {
            return 0;
        }
        switch (os) {
            case "0": {
                return 1;
            }
            case "1": {
                return 2;
            }
        }
        return 0;
    }

    private Guangtui.Imp convertImp(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        CommonImp commonImp = adxCommonBidRequest.getImpList().get(0);
        Guangtui.Imp.Builder adPosInfo = Guangtui.Imp.newBuilder();
        adPosInfo.setId(commonImp.getId()).setTagid(dspInfo.getDspTagId()).setSubtagid(commonImp.getExternalAdBlockId()).setDeeplink(commonImp.isOpenDeepLink() ? 1 : 0).setStyle(Integer.parseInt(dspInfo.getDspResId()));
        if (CollectionUtils.isNotEmpty(commonImp.getFilteringSize())) {
            CommonSizeInfo commonSizeInfo = commonImp.getFilteringSize().get(0);
            adPosInfo.setHeight(commonSizeInfo != null ? Integer.valueOf(commonSizeInfo.getHeight()) : null).setWidth(commonSizeInfo != null ? Integer.valueOf(commonSizeInfo.getWidth()) : null);
        }
        long floorPrice = CalculateFloorPrice.getFloorPrice(commonImp.getFloorPrice(), dspInfo);
        adPosInfo.setBidfloor((int)floorPrice);
        return adPosInfo.build();
    }
}

