/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.firefly.convert;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonContext;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonCreative;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonDesc;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonIcon;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonImage;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonSeatBid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonTitle;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonVideo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.firefly.bean.ActionType;
import cn.com.duiba.tuia.dsp.engine.api.dsp.firefly.bean.Adm;
import cn.com.duiba.tuia.dsp.engine.api.dsp.firefly.bean.AndroidApp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.firefly.bean.Bid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.firefly.bean.FireFlyResp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.firefly.bean.Image;
import cn.com.duiba.tuia.dsp.engine.api.dsp.firefly.bean.SeatBid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.firefly.bean.Video;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FireflyRespConvert {
    public AdxCommonBidResponse convert(FireFlyResp fireFlyResp) {
        if (fireFlyResp == null) {
            return null;
        }
        AdxCommonBidResponse commonBidResponse = new AdxCommonBidResponse();
        commonBidResponse.setDspId(DspEnum.DSP_14.getDspId());
        List<SeatBid> seatBid = fireFlyResp.getSeatBid();
        List<CommonSeatBid> commonSeatBids = this.seatBidConvert(seatBid);
        commonBidResponse.setCommonSeatBidList(commonSeatBids);
        return commonBidResponse;
    }

    private List<CommonSeatBid> seatBidConvert(List<SeatBid> seatBid) {
        ArrayList<CommonSeatBid> commonSeatBidList = new ArrayList<CommonSeatBid>();
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        commonSeatBidList.add(commonSeatBid);
        CommonContext context = new CommonContext();
        commonSeatBid.setCommonContext(context);
        Bid bid = seatBid.get(0).getBid().get(0);
        CommonCreative commonCreative = new CommonCreative();
        commonSeatBid.setCommonCreative(commonCreative);
        commonSeatBid.setExposureCallbackUrls(bid.getShowUrl());
        commonSeatBid.setClickCallbackUrls(bid.getClickUrl());
        commonSeatBid.setWinCallbackUrls(bid.getNurl());
        commonSeatBid.setPrice(Double.valueOf(bid.getPrice()));
        Adm adm = bid.getAdm();
        if (StringUtils.isNotBlank((CharSequence)adm.getTitle())) {
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle(adm.getTitle());
            commonCreative.setCommonTitle(commonTitle);
        }
        if (StringUtils.isNotBlank((CharSequence)adm.getDesc())) {
            CommonDesc commonDesc = new CommonDesc();
            commonDesc.setDesc(adm.getDesc());
            commonCreative.setCommonDesc(commonDesc);
        }
        if (StringUtils.isNotBlank((CharSequence)adm.getIcon())) {
            CommonIcon commonIcon = new CommonIcon();
            commonIcon.setUrl(adm.getIcon());
            commonCreative.setCommonIcon(commonIcon);
        }
        if (adm.getVideoInfo() != null) {
            ArrayList<CommonVideo> commonVideoList = new ArrayList<CommonVideo>();
            Video videoInfo = adm.getVideoInfo();
            CommonVideo commonVideo = new CommonVideo();
            commonVideo.setVideoUrl(videoInfo.getUrl());
            commonVideo.setResolutionX(videoInfo.getWidth());
            commonVideo.setResolutionY(videoInfo.getHeight());
            if (videoInfo.getDuration() != 0) {
                commonVideo.setDuration(new BigDecimal(videoInfo.getDuration()));
            }
            commonVideo.setSize(videoInfo.getSize());
            commonVideo.setCoverUrl(videoInfo.getCoverUrl());
            commonVideo.setCoverWidth(videoInfo.getCoverWidth());
            commonVideo.setCoverHeight(videoInfo.getCoverHeight());
            commonVideoList.add(commonVideo);
            commonCreative.setCommonVideoList(commonVideoList);
        } else {
            Image image2 = adm.getImgInfo().get(0);
            ArrayList<CommonImage> commonImageList = new ArrayList<CommonImage>();
            CommonImage commonImage = new CommonImage();
            commonImage.setUrl(image2.getUrl());
            commonImage.setWidth(image2.getWidth());
            commonImage.setHeight(image2.getHeight());
            commonImageList.add(commonImage);
            commonCreative.setCommonImageList(commonImageList);
        }
        if (adm.getAndroidApp() != null) {
            AndroidApp androidApp = adm.getAndroidApp();
            commonCreative.setAppBundle(androidApp.getPackageName());
            commonCreative.setAppName(androidApp.getAppName());
        }
        if (adm.getLandingPage() != null) {
            String url = adm.getLandingPage().getUrl();
            if (StringUtils.isEmpty((CharSequence)url)) {
                url = adm.getLandingPage().getLpOpenUrl();
            }
            commonCreative.setLandingPageUrl(url);
        }
        if (adm.getActionType() == ActionType.DEEPLINK.getCode()) {
            commonCreative.setDeepLinkUrl(adm.getDeeplink());
            context.setDeepLinkUrl(adm.getDeeplink());
        }
        if (adm.getActionType() == ActionType.QUICK_APP.getCode()) {
            commonCreative.setDeepLinkUrl(adm.getQuickAppLink());
            context.setDeepLinkUrl(adm.getQuickAppLink());
        }
        return commonSeatBidList;
    }
}

