/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.iqiyi.convert;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonContext;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonCreative;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonDesc;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonIcon;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonImage;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonSeatBid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonTitle;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonVideo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.iqiyi.bean.IqiyiBid;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IqiyiRespConvert {
    private static final Logger log = LoggerFactory.getLogger(IqiyiRespConvert.class);

    public AdxCommonBidResponse respConvert(IqiyiBid.BidResponse response) {
        if (response == null) {
            return null;
        }
        if (CollectionUtils.isEmpty(response.getBidList())) {
            return null;
        }
        AdxCommonBidResponse commonBidResponse = new AdxCommonBidResponse();
        commonBidResponse.setRequestId(response.getId());
        commonBidResponse.setDspId(DspEnum.DSP_16.getDspId());
        List<CommonSeatBid> commonSeatBids = this.seatConvert(response.getBidList());
        if (CollectionUtils.isEmpty(commonSeatBids)) {
            return null;
        }
        commonBidResponse.setCommonSeatBidList(commonSeatBids);
        return commonBidResponse;
    }

    private List<CommonSeatBid> seatConvert(List<IqiyiBid.BidResponse.Bid> bidList) {
        ArrayList<CommonSeatBid> commonSeatBidList = new ArrayList<CommonSeatBid>();
        for (IqiyiBid.BidResponse.Bid bid : bidList) {
            CommonSeatBid commonSeatBid = new CommonSeatBid();
            CommonContext context = new CommonContext();
            CommonCreative commonCreative = new CommonCreative();
            if (bid == null) continue;
            commonSeatBid.setPrice(Double.valueOf(bid.getPrice()));
            commonSeatBid.setAdvertiserId("50582");
            IqiyiBid.AdActionType action = bid.getAction();
            if (bid.hasOpening()) {
                this.dealOpen(bid, commonCreative, commonSeatBid, context);
            }
            if (bid.hasAdVideo()) {
                this.dealAdVideo(bid, commonCreative, commonSeatBid, context);
            }
            if (bid.hasAdmnative()) {
                this.dealNative(bid, commonCreative, commonSeatBid, context);
            }
            if (IqiyiBid.AdActionType.DOWNLOAD_APP.equals((Object)action)) {
                commonCreative.setLandingPageUrl(bid.getAppDescPageUrl());
                if (StringUtils.isNotEmpty((CharSequence)bid.getApkName())) {
                    commonCreative.setAppBundle(bid.getApkName());
                }
                if (StringUtils.isNotBlank((CharSequence)bid.getAppName())) {
                    commonCreative.setAppName(bid.getAppName());
                }
                if (StringUtils.isNotBlank((CharSequence)bid.getAppVersion())) {
                    commonCreative.setAppVersion(bid.getAppVersion());
                }
                commonCreative.setDeveloper(bid.getAppDeveloper());
                commonCreative.setAppFeature(bid.getAppFeature());
                commonCreative.setPermissionLink(bid.getAppPermission());
                commonCreative.setPrivacyPolicyLink(bid.getAppPrivacy());
                commonCreative.setDownloadUrl(bid.getLink().getCurl());
                IqiyiBid.BidResponse.Bid.DownloadTracker downloadTrackers = bid.getLink().getDownloadtrackers();
                commonSeatBid.setStartDownloadUrls((List<String>)downloadTrackers.getStartdownloadList());
                commonSeatBid.setFinishDownloadUrls((List<String>)downloadTrackers.getFinishdownloadList());
                commonSeatBid.setStartInstallUrls((List<String>)downloadTrackers.getStartinstallList());
                commonSeatBid.setFinishInstallUrls((List<String>)downloadTrackers.getFinishinstallList());
            }
            commonSeatBidList.add(commonSeatBid);
            commonSeatBid.setCommonContext(context);
            commonSeatBid.setCommonCreative(commonCreative);
        }
        return commonSeatBidList;
    }

    private void dealOpen(IqiyiBid.BidResponse.Bid bid, CommonCreative commonCreative, CommonSeatBid commonSeatBid, CommonContext context) {
        IqiyiBid.BidResponse.Bid.Link link = bid.getLink();
        context.setDeepLinkUrl(link.getDeeplink());
        commonCreative.setLandingPageUrl(link.getCurl());
        commonSeatBid.setExposureCallbackUrls((List<String>)link.getImptrackersList());
        commonSeatBid.setClickCallbackUrls((List<String>)link.getClicktrackersList());
        if (IqiyiBid.BidResponse.Bid.CreativeType.VIDEO.equals((Object)bid.getCreativeType())) {
            ArrayList<CommonVideo> commonVideoList = new ArrayList<CommonVideo>();
            IqiyiBid.BidResponse.Bid.AdVideo adVideo = bid.getAdVideo();
            CommonVideo commonVideo = new CommonVideo();
            commonVideo.setVideoUrl(bid.getAdUrl());
            commonVideo.setDuration(new BigDecimal(adVideo.getDuration()));
            commonVideo.setResolutionX(bid.getAdWidth());
            commonVideo.setResolutionY(bid.getAdHeight());
            commonVideoList.add(commonVideo);
            commonCreative.setCommonVideoList(commonVideoList);
        } else if (IqiyiBid.BidResponse.Bid.CreativeType.IMG.equals((Object)bid.getCreativeType())) {
            ArrayList<CommonImage> commonImageList = new ArrayList<CommonImage>();
            CommonImage commonImage = new CommonImage();
            commonImage.setUrl(bid.getAdUrl());
            commonImage.setWidth(bid.getAdWidth());
            commonImage.setHeight(bid.getAdHeight());
            commonImageList.add(commonImage);
            commonCreative.setCommonImageList(commonImageList);
        }
        if (StringUtils.isNotBlank((CharSequence)bid.getTitle())) {
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle(bid.getTitle());
            commonCreative.setCommonTitle(commonTitle);
        }
        if (StringUtils.isNotBlank((CharSequence)bid.getDescription())) {
            CommonDesc commonDesc = new CommonDesc();
            commonDesc.setDesc(bid.getDescription());
            commonCreative.setCommonDesc(commonDesc);
        }
    }

    private void dealAdVideo(IqiyiBid.BidResponse.Bid bid, CommonCreative commonCreative, CommonSeatBid commonSeatBid, CommonContext context) {
        IqiyiBid.BidResponse.Bid.AdmVideo admvideo = bid.getAdmvideo();
        if (CollectionUtils.isNotEmpty(admvideo.getImgsList())) {
            ArrayList<CommonImage> commonImageList = new ArrayList<CommonImage>();
            for (IqiyiBid.BidResponse.Bid.Image image2 : admvideo.getImgsList()) {
                CommonImage commonImage = new CommonImage();
                commonImage.setUrl(image2.getUrl());
                commonImage.setWidth(image2.getW());
                commonImage.setHeight(image2.getH());
                commonImageList.add(commonImage);
            }
            commonCreative.setCommonImageList(commonImageList);
        }
        if (admvideo.hasVideo()) {
            ArrayList<CommonVideo> commonVideoList = new ArrayList<CommonVideo>();
            IqiyiBid.BidResponse.Bid.Video video = admvideo.getVideo();
            CommonVideo commonVideo = new CommonVideo();
            commonVideo.setVideoUrl(video.getUrl());
            commonVideo.setResolutionX(video.getW());
            commonVideo.setResolutionY(video.getH());
            if (video.hasDuration()) {
                commonVideo.setDuration(new BigDecimal(video.getDuration()));
            }
            commonVideoList.add(commonVideo);
            commonCreative.setCommonVideoList(commonVideoList);
        }
        if (admvideo.hasTitle()) {
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle(admvideo.getTitle());
            commonCreative.setCommonTitle(commonTitle);
        }
        if (admvideo.hasDesc()) {
            CommonDesc commonDesc = new CommonDesc();
            commonDesc.setDesc(admvideo.getDesc());
            commonCreative.setCommonDesc(commonDesc);
        }
        commonCreative.setAppBundle(admvideo.getPackageName());
        commonCreative.setAppName(admvideo.getAppName());
        commonCreative.setIconUrl(admvideo.getAppIcon());
        commonCreative.setAppVersion(admvideo.getAppVersion());
    }

    private void dealNative(IqiyiBid.BidResponse.Bid bid, CommonCreative commonCreative, CommonSeatBid commonSeatBid, CommonContext context) {
        IqiyiBid.BidResponse.Bid.AdmNative admnative = bid.getAdmnative();
        if (StringUtils.isNotBlank((CharSequence)admnative.getTitle())) {
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle(admnative.getTitle());
            commonCreative.setCommonTitle(commonTitle);
        }
        if (CollectionUtils.isNotEmpty(admnative.getImgsList())) {
            ArrayList<CommonImage> commonImageList = new ArrayList<CommonImage>();
            for (IqiyiBid.BidResponse.Bid.Image image2 : admnative.getImgsList()) {
                CommonImage commonImage = new CommonImage();
                commonImage.setUrl(image2.getUrl());
                commonImage.setWidth(image2.getW());
                commonImage.setHeight(image2.getH());
                commonImageList.add(commonImage);
            }
            if (CollectionUtils.isNotEmpty(commonImageList)) {
                commonCreative.setCommonImageList(commonImageList);
            }
        }
        if (admnative.hasVideo()) {
            ArrayList<CommonVideo> commonVideoList = new ArrayList<CommonVideo>();
            IqiyiBid.BidResponse.Bid.Video video = admnative.getVideo();
            CommonVideo commonVideo = new CommonVideo();
            commonVideo.setVideoUrl(video.getUrl());
            commonVideo.setVideoUrl(video.getUrl());
            commonVideo.setResolutionX(video.getW());
            commonVideo.setResolutionY(video.getH());
            if (video.hasDuration()) {
                commonVideo.setDuration(new BigDecimal(video.getDuration()));
            }
            commonVideoList.add(commonVideo);
            commonCreative.setCommonVideoList(commonVideoList);
        }
        if (admnative.hasLink()) {
            IqiyiBid.BidResponse.Bid.Link link = admnative.getLink();
            context.setDeepLinkUrl(link.getDeeplink());
            commonCreative.setLandingPageUrl(link.getCurl());
            commonSeatBid.setExposureCallbackUrls((List<String>)link.getImptrackersList());
            commonSeatBid.setClickCallbackUrls((List<String>)link.getClicktrackersList());
        }
        commonCreative.setAppBundle(admnative.getPackageName());
        commonCreative.setAppName(admnative.getAppName());
        commonCreative.setIconUrl(admnative.getAppIcon());
        commonCreative.setAppVersion(admnative.getAppVersion());
        if (StringUtils.isNotBlank((CharSequence)admnative.getAppIcon())) {
            CommonIcon commonIcon = new CommonIcon();
            commonIcon.setUrl(admnative.getAppIcon());
            commonCreative.setCommonIcon(commonIcon);
        }
    }
}

