/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.youku.convert;

import cn.com.duiba.tuia.adx.center.api.common.Caid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AppReplace;
import cn.com.duiba.tuia.dsp.engine.api.dsp.CalculateFloorPrice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonAppInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonDevice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonImp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.youku.param.App;
import cn.com.duiba.tuia.dsp.engine.api.dsp.youku.param.BidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.youku.param.Device;
import cn.com.duiba.tuia.dsp.engine.api.dsp.youku.param.Imp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.youku.param.User;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RequestConvert {
    @Autowired
    private AppReplace appReplace;

    public BidRequest convert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        BidRequest bidRequest = new BidRequest();
        bidRequest.setId(adxCommonBidRequest.getRequestId());
        bidRequest.setMedia_id("100317");
        bidRequest.setApp_id("1000253");
        List<Imp> imp = this.impConvert(adxCommonBidRequest, dspInfo);
        if (CollectionUtils.isEmpty(imp)) {
            return null;
        }
        bidRequest.setImp(imp);
        App app = this.appConvert(adxCommonBidRequest, dspInfo);
        bidRequest.setApp(app);
        Device device = this.deviceConvert(adxCommonBidRequest, dspInfo);
        bidRequest.setDevice(device);
        User user = new User();
        bidRequest.setUser(user);
        return bidRequest;
    }

    private Device deviceConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        CommonDevice commonDevice = adxCommonBidRequest.getDevice();
        Device device = new Device();
        device.setUa(commonDevice.getUa());
        device.setIp(commonDevice.getIp());
        String os = commonDevice.getOs();
        if ("1".equals(os)) {
            device.setOs("ios");
        } else if ("0".equals(os)) {
            device.setOs("android");
        } else {
            device.setOs("unknown");
        }
        device.setOsv(commonDevice.getOsVersion());
        device.setDevice_type(1);
        String connectionType = commonDevice.getConnectionType();
        if ("1".equals(connectionType)) {
            device.setConnection_type(1);
        } else if ("2".equals(connectionType)) {
            device.setConnection_type(2);
        } else if ("4".equals(connectionType)) {
            device.setConnection_type(4);
        } else if ("5".equals(connectionType)) {
            device.setConnection_type(5);
        } else if ("6".equals(connectionType)) {
            device.setConnection_type(6);
        } else if ("7".equals(connectionType)) {
            device.setConnection_type(7);
        }
        String carrier = commonDevice.getCarrier();
        if ("1".equals(carrier)) {
            device.setCarrier("1");
        } else if ("2".equals(carrier)) {
            device.setCarrier("2");
        } else if ("3".equals(carrier)) {
            device.setCarrier("3");
        } else {
            device.setCarrier("4");
        }
        device.setModel(commonDevice.getModel());
        device.setBrand(commonDevice.getMake());
        device.setIdfa(commonDevice.getIdFa());
        device.setIdfa_md5(commonDevice.getIdFaMd5());
        device.setOaid(commonDevice.getOaId());
        device.setOaid_md5(commonDevice.getOaIdMd5());
        device.setImei(commonDevice.getImei());
        device.setImei_md5(commonDevice.getImeiMd5());
        device.setMac(commonDevice.getMac());
        device.setMac_md5(commonDevice.getMacMd5());
        if (!CollectionUtils.isEmpty(commonDevice.getCaids())) {
            ArrayList<cn.com.duiba.tuia.dsp.engine.api.dsp.youku.param.Caid> caids = new ArrayList<cn.com.duiba.tuia.dsp.engine.api.dsp.youku.param.Caid>();
            for (Caid commonCaid : commonDevice.getCaids()) {
                cn.com.duiba.tuia.dsp.engine.api.dsp.youku.param.Caid caid = new cn.com.duiba.tuia.dsp.engine.api.dsp.youku.param.Caid();
                caid.setCaid(commonCaid.getId());
                caid.setVersion(commonCaid.getVersion());
                caids.add(caid);
            }
            device.setCaid(caids);
        }
        device.setAndroid_id(commonDevice.getDpId());
        return device;
    }

    private App appConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        CommonAppInfo appInfo = adxCommonBidRequest.getAppInfo();
        CommonAppInfo replaceApp = this.appReplace.getReplaceApp(dspInfo.getIdeaId());
        App app = new App();
        if (replaceApp != null) {
            app.setName(replaceApp.getName());
            app.setPackage_name(replaceApp.getBundle());
        } else {
            app.setName(appInfo.getName());
            app.setPackage_name(appInfo.getBundle());
        }
        return app;
    }

    private List<Imp> impConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        List<CommonImp> commonImps = adxCommonBidRequest.getImpList();
        if (CollectionUtils.isEmpty(commonImps)) {
            return null;
        }
        ArrayList<Imp> impList = new ArrayList<Imp>();
        for (CommonImp commonImp : commonImps) {
            Imp imp = new Imp();
            imp.setId(commonImp.getId());
            imp.setSlot_id(dspInfo.getDspTagId());
            long floorPrice = CalculateFloorPrice.getFloorPrice(commonImp.getFloorPrice(), dspInfo);
            imp.setBid_floor((int)floorPrice);
            imp.setAd_num(1);
            impList.add(imp);
        }
        return impList;
    }
}

