/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.feisuo;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.feisuo.FeiSuoDspProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.feisuo.convert.FeiSuoDspReqConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.feisuo.convert.FeiSuoDspRespConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.feisuo.proto.FeiSuoProtoBid;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Component
public class FeiSuoDspInvoker
extends AbstractDspCaller<FeiSuoProtoBid.FlyingShuttleBidResponse, FeiSuoProtoBid.FlyingShuttleBidRequest> {
    private static final Logger log = LoggerFactory.getLogger(FeiSuoDspInvoker.class);
    @Autowired
    private FeiSuoDspReqConvert feiSuoDspReqConvert;
    @Autowired
    private FeiSuoDspRespConvert feiSuoDspRespConvert;
    @Autowired
    private FeiSuoDspProperties feiSuoDspProperties;
    @Resource(name="dspRestTemplate")
    private RestTemplate restTemplate;

    @Override
    protected FeiSuoProtoBid.FlyingShuttleBidResponse invokeDsp(FeiSuoProtoBid.FlyingShuttleBidRequest flyingShuttleBidRequest) {
        if (flyingShuttleBidRequest == null) {
            return null;
        }
        Cat.logMetricForCount((String)"\u98de\u68adDSP\u8c03\u7528");
        try {
            return (FeiSuoProtoBid.FlyingShuttleBidResponse)CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(this.feiSuoDspProperties.getUrl(), flyingShuttleBidRequest), (String)"invokeDSP", (String)"feisuoDsp");
        }
        catch (Throwable t) {
            log.warn("\u98de\u68adDSP\u8c03\u7528\u5f02\u5e38", t);
            return null;
        }
    }

    private FeiSuoProtoBid.FlyingShuttleBidResponse doHttpInvoke(String url, FeiSuoProtoBid.FlyingShuttleBidRequest flyingShuttleBidRequest) throws IOException {
        ResponseEntity resEntity;
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/proto");
        HttpEntity requestEntity = new HttpEntity((Object)flyingShuttleBidRequest.toByteArray(), (MultiValueMap)headers);
        try {
            resEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, org.springframework.core.io.Resource.class, new Object[0]);
        }
        catch (Exception e) {
            if (!(e instanceof ResourceAccessException)) {
                SamplerLog.warn((String)"\u98de\u68ad\u8c03\u7528\u5f02\u5e38", (Object[])new Object[]{e});
            }
            return null;
        }
        org.springframework.core.io.Resource resource = (org.springframework.core.io.Resource)resEntity.getBody();
        if (resource == null) {
            return null;
        }
        FeiSuoProtoBid.FlyingShuttleBidResponse body = FeiSuoProtoBid.FlyingShuttleBidResponse.parseFrom(resource.getInputStream());
        if (body != null && body.getCode() == 0 && CollectionUtils.isNotEmpty(body.getAdsList())) {
            Cat.logMetricForCount((String)"\u98de\u68adDSP\u8fd4\u56de");
            return body;
        }
        return null;
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        return null;
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_29.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_29;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        return url;
    }

    @Override
    public FeiSuoProtoBid.FlyingShuttleBidRequest convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        return this.feiSuoDspReqConvert.convertReq(adxCommonBidRequest, dspInfo);
    }

    @Override
    public AdxCommonBidResponse convertResp(FeiSuoProtoBid.FlyingShuttleBidResponse flyingShuttleBidResponse) throws DspException {
        if (flyingShuttleBidResponse == null) {
            return null;
        }
        List<FeiSuoProtoBid.Ad> adsList = flyingShuttleBidResponse.getAdsList();
        if (CollectionUtils.isEmpty(adsList)) {
            return null;
        }
        return this.feiSuoDspRespConvert.convertResp(flyingShuttleBidResponse);
    }
}

