package cn.com.duiba.tuia.dsp.engine.api.dsp.feisuo;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.feisuo.convert.FeiSuoDspReqConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.feisuo.convert.FeiSuoDspRespConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.feisuo.proto.FeiSuoProtoBid;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;

@Component
@Slf4j
public class FeiSuoDspInvoker extends AbstractDspCaller<FeiSuoProtoBid.FlyingShuttleBidResponse, FeiSuoProtoBid.FlyingShuttleBidRequest> {

    @Autowired
    private FeiSuoDspReqConvert feiSuoDspReqConvert;
    @Autowired
    private FeiSuoDspRespConvert feiSuoDspRespConvert;
    @Autowired
    private FeiSuoDspProperties feiSuoDspProperties;
    @Resource(name = "dspRestTemplate")
    private RestTemplate restTemplate;


    @Override
    protected FeiSuoProtoBid.FlyingShuttleBidResponse invokeDsp(FeiSuoProtoBid.FlyingShuttleBidRequest flyingShuttleBidRequest) {
        if (flyingShuttleBidRequest == null) {
            return null;
        }
        Cat.logMetricForCount("飞梭DSP调用");
        try {
            return CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(feiSuoDspProperties.getUrl(), flyingShuttleBidRequest), "invokeDSP", "feisuoDsp");
        } catch (Throwable t) {
            log.warn("飞梭DSP调用异常", t);
        }
        return null;
    }

    private FeiSuoProtoBid.FlyingShuttleBidResponse doHttpInvoke(String url, FeiSuoProtoBid.FlyingShuttleBidRequest flyingShuttleBidRequest) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/proto");
        HttpEntity<byte[]> requestEntity = new HttpEntity<>(flyingShuttleBidRequest.toByteArray(), headers);
        ResponseEntity<org.springframework.core.io.Resource> resEntity;
        try {
            resEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity, org.springframework.core.io.Resource.class);
        } catch (Exception e) {
            if (!(e instanceof ResourceAccessException)) {
                SamplerLog.warn("飞梭调用异常", e);
            }
            return null;
        }
        org.springframework.core.io.Resource resource = resEntity.getBody();
        if (resource == null) {
            return null;
        }
        FeiSuoProtoBid.FlyingShuttleBidResponse body = FeiSuoProtoBid.FlyingShuttleBidResponse.parseFrom(resource.getInputStream());
        if (body != null && body.getCode() == 0 && CollectionUtils.isNotEmpty(body.getAdsList())) {
            Cat.logMetricForCount("飞梭DSP返回");
            return body;
        }
        return null;
    }


    @Override
    public String priceEncryption(BigDecimal price) {
        return null;
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_29.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_29;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        return url;
    }


    @Override
    public FeiSuoProtoBid.FlyingShuttleBidRequest convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        return feiSuoDspReqConvert.convertReq(adxCommonBidRequest, dspInfo);
    }

    @Override
    public AdxCommonBidResponse convertResp(FeiSuoProtoBid.FlyingShuttleBidResponse flyingShuttleBidResponse) throws DspException {
        if (flyingShuttleBidResponse == null) {
            return null;
        }
        List<FeiSuoProtoBid.Ad> adsList = flyingShuttleBidResponse.getAdsList();
        if (CollectionUtils.isEmpty(adsList)) {
            return null;
        }
        return feiSuoDspRespConvert.convertResp(flyingShuttleBidResponse);
    }
}
