package cn.com.duiba.api.bo.mq;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;

/**
 * Created by zhangshun on 2018/11/29,20:02:36.
 */
public class SupplierCallbackDto implements Serializable {

    /**
     * 订单ID, 真实是 Long 型
     */
    private String orderId;
    /**
     * AppID, 真实是 Long 型
     */
    private String appId;
    /**
     * 买家ID, 真实是 Long 型
     */
    private String consumerId;
    private String callbackType;
    private String url;
    private String body;
    private String errorMessage;

    private boolean success = false;
    private boolean fail = false;
    private String error4Admin;
    private String error4Developer;
    private String error4Consumer;


    private String qbStatus;
    private String qbParams;
    private String qbFromSupplier;

    /**
     * 供应商名称
     * QB: kaixin
     * 话费:juhe,
     */
    private String supplierName;

    /**
     * 供应商业务Id
     * 话费: sporder_id:聚合订单号
     */
    private String supplierBizId;

    /**
     * 供应商状态
     */
    private String supplierStatus;

    /**
     * 供应商回调参数
     * QB:account_no=3294542032face_price=1order_no=82912135138265C0986order_time=20181120151240order_type=10partner_id=10440863pay_money=0.94profit=0sign_type=MD5status=SUCCESSstream_id=10628182017sign=b42f6088a3e121b94e2e5c9a13d101f4
     */
    private String supplierParams;

    /**
     * 发货单ID, 真实是 Long 型
     */
    private String supplierOrderId;

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getSupplierOrderId() {
        return supplierOrderId;
    }

    public void setSupplierOrderId(String supplierOrderId) {
        this.supplierOrderId = supplierOrderId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getSupplierBizId() {
        return supplierBizId;
    }

    public void setSupplierBizId(String supplierBizId) {
        this.supplierBizId = supplierBizId;
    }

    public String getSupplierStatus() {
        return supplierStatus;
    }

    public void setSupplierStatus(String supplierStatus) {
        this.supplierStatus = supplierStatus;
    }

    public String getSupplierParams() {
        return supplierParams;
    }

    public void setSupplierParams(String supplierParams) {
        this.supplierParams = supplierParams;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(String consumerId) {
        this.consumerId = consumerId;
    }

    public String getCallbackType() {
        return callbackType;
    }

    public void setCallbackType(String callbackType) {
        this.callbackType = callbackType;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public boolean isFail() {
        return fail;
    }

    public void setFail(boolean fail) {
        this.fail = fail;
    }

    public String getError4Admin() {
        return error4Admin;
    }

    public void setError4Admin(String error4Admin) {
        this.error4Admin = error4Admin;
    }

    public String getError4Developer() {
        return error4Developer;
    }

    public void setError4Developer(String error4Developer) {
        this.error4Developer = error4Developer;
    }

    public String getError4Consumer() {
        return error4Consumer;
    }

    public void setError4Consumer(String error4Consumer) {
        this.error4Consumer = error4Consumer;
    }

    public String getQbStatus() {
        return qbStatus;
    }

    public void setQbStatus(String qbStatus) {
        this.qbStatus = qbStatus;
    }

    public String getQbParams() {
        return qbParams;
    }

    public void setQbParams(String qbParams) {
        this.qbParams = qbParams;
    }

    public String getQbFromSupplier() {
        return qbFromSupplier;
    }

    public void setQbFromSupplier(String qbFromSupplier) {
        this.qbFromSupplier = qbFromSupplier;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
