package cn.com.duiba.api.enums.mq;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * ClassName:RocketMqTagEnum<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: mq tag 枚举类
 * @date 创建时间：2018/4/21  10:27
 * @since JDK 1.8
 **/
public enum RocketMqTagEnum {

    SUB_CREDITS_NORMAL("sub_credits_normal", "常规扣积分"),
    SUB_CREDITS_ZERO("sub_credits_zero","扣0积分"),
    TAKE_PRIZE("takePrize", "活动工具领奖"),
    TAKE_PRIZE_NGAME("takePrizeNgame", "活动工具领奖ngame"),
    TAKE_PRIZE_MOMO("takePrizeMomo", "活动工具领奖陌陌"),
    TAKE_PRIZE_PLUGIN("takePrizePlugin", "插件领奖"),
    TAKE_PRIZE_PLUGIN_COMMON("takePrizePluginCommon", "插件通用领奖"),
    TAKE_PRIZE_PLUGIN_ITEM("takePrizePluginItem", "插件指定商品id的发奖形式"),
    TAKE_PRIZE_THROUGH("takePrizeThrough", "活动工具-闯关游戏领奖"),
    TAKE_PRIZE_COLLECT_CARD_DIRECT("takePrizeCollectCardDirect", "集卡直接发奖"),
    VISIT_TIME("vist", "活动参与次数"),

    JOIN_TIME("join","活动参与次数"),
    JOIN_TIME_PLUGIN("pluginJoin","插件活动参与次数"),
    JOIN_TIME_COMM("commJoin","通用参与次数"),

    KV_MUL_INSERT("mulInsert", "kv批量插入"),
    KV_INSERT_INCREASE("insertOrIncrease", "kv单条插入或者增长"),
    KV_INSERT_UPDATE("insertOrUpdate", "kv单条插入或者更新"),
    KV_BATCH_INCREASE("batchIncrease", "kv批量插入，用于搜狐新闻临时需求"),

    TH_SUB_CREDITS("tag_new", "第三方服务扣积分"),
    REFLECT_WALLET_RECORD("reflect_wallet_record","钱包账户流水体现更新"),
    NOTIFY_QUEUE_TAG("notify_queue_tag","通知开发者tag"),
    EXPIRE_WALLET_RECORD("expire_wallet_record","钱包账户流水过期更新"),
    KV_HB_BATCH_UPSERT("batchUpsert","kvtable HBase批量新增或更新的tags"),
    KV_HB_SINGLE_UPSERT("singleUpsert","kvtable HBase单条新增或更新tags"),
    THIRDPARTY_DING_TEXT_MSG("dingTextMsg","thirdParty服务中发送钉钉文本消息类型"),
    ACR_ADD_SCORE("addScore","activityRank 增加分数tag"),

    // 供应商发货回调Tag
    SSC_OBJECT_CONFIRM("object_confirm","供应商实物确认发货"),
    SSC_COUPON_CONFIRM("coupon_confirm","供应商优惠券确认发货"),
    SSC_ALIPAY_CONFIRM("alipay_confirm","供应商支付宝确认发货"),
    SSC_QB_CONFIRM("qb_confirm","供应商QB确认发货"),
    SSC_PHONEBILL_CONFIRM("phonebill_confirm","供应商话费确认发货"),

    // 供应商取消发货Tag
    SSC_OBJECT_CANCEL("object_cancel","供应商实物取消发货"),
    ;

    public static final ImmutableMap<String, RocketMqTagEnum> ALL_TAG_MAP;

    static {
        Map<String, RocketMqTagEnum> temp = Maps.newHashMap();
        for (RocketMqTagEnum tag : values()) {
            temp.put(tag.getTag(), tag);
        }
        ALL_TAG_MAP = ImmutableMap.copyOf(temp);
    }

    /** tag名 */
    private String tag;
    /** 描述说明 */
    private String desc;

    RocketMqTagEnum(String tag, String desc) {
        this.tag = tag;
        this.desc = desc;
    }

    public String getTag() {
        return tag;
    }

    public String getDesc() {
        return desc;
    }
}
