/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.api.tools;

import cn.com.duiba.api.enums.ActivityToolTypeEnum;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ActivityToolTypeUtil {
    private static final String FORMAT = "_";
    private static final ImmutableSet<Integer> typeSet = ImmutableSet.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object[])new Integer[0]);
    private static final ImmutableSet<Integer> operatingTypeSet = ImmutableSet.of((Object)6, (Object)7, (Object)8, (Object)9, (Object)11, (Object)12, (Object[])new Integer[]{101});

    private ActivityToolTypeUtil() {
    }

    public static String getTypeNameBySubType(String subType) {
        if (StringUtils.isEmpty((String)subType)) {
            return "";
        }
        String newSubType = subType.split(FORMAT)[0];
        return ActivityToolTypeEnum.getBySubType(newSubType).getName();
    }

    public static String getTypeNameByType(Integer type) {
        String typeName = "";
        if (!typeSet.contains((Object)type)) {
            return typeName;
        }
        if (ActivityToolTypeEnum.TIGER.getType().equals(type)) {
            return ActivityToolTypeEnum.TIGER.getName();
        }
        if (ActivityToolTypeEnum.CUSTOM.getType().equals(type)) {
            return ActivityToolTypeEnum.CUSTOM.getName();
        }
        List<ActivityToolTypeEnum> typeEnums = ActivityToolTypeEnum.getByType(type);
        if (CollectionUtils.isEmpty(typeEnums)) {
            return typeName;
        }
        List typeNames = typeEnums.stream().filter(typeEnum -> typeEnum.getType().equals(type)).map(ActivityToolTypeEnum::getName).collect(Collectors.toList());
        return (String)typeNames.get(0);
    }

    public static String getTypeNameByOperatingType(Integer operatingType) {
        String typeName = "";
        if (!operatingTypeSet.contains((Object)operatingType)) {
            return typeName;
        }
        if (ActivityToolTypeEnum.TIGER.getOperatingType().equals(operatingType)) {
            return ActivityToolTypeEnum.TIGER.getName();
        }
        if (ActivityToolTypeEnum.CUSTOM.getOperatingType().equals(operatingType)) {
            return ActivityToolTypeEnum.CUSTOM.getName();
        }
        List<ActivityToolTypeEnum> typeEnums = ActivityToolTypeEnum.getByOperatingType(operatingType);
        if (CollectionUtils.isEmpty(typeEnums)) {
            return typeName;
        }
        return typeEnums.get(0).getName();
    }

    public static String getNameByOpTypeAndCustomType(Integer operatingType, String customSubType) {
        String typeName = "";
        if (!operatingTypeSet.contains((Object)operatingType)) {
            return typeName;
        }
        if (ActivityToolTypeEnum.TIGER.getOperatingType().equals(operatingType)) {
            return ActivityToolTypeEnum.TIGER.getName();
        }
        List<ActivityToolTypeEnum> typeEnums = ActivityToolTypeEnum.getByOperatingType(operatingType);
        if (CollectionUtils.isEmpty(typeEnums)) {
            return typeName;
        }
        if (typeEnums.size() == 1) {
            return typeEnums.get(0).getName();
        }
        if (StringUtils.isBlank((String)customSubType)) {
            return typeEnums.get(0).getName();
        }
        List typeNames = typeEnums.stream().filter(typeEnum -> typeEnum.getCustomSubType().equals(customSubType)).map(ActivityToolTypeEnum::getName).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(typeNames)) {
            return typeName;
        }
        return (String)typeNames.get(0);
    }
}

