/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.api.tools;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GZIPCompressUtil {
    private static final Logger LOG = LoggerFactory.getLogger(GZIPCompressUtil.class);

    private GZIPCompressUtil() {
    }

    public static byte[] gzip(byte[] bytes) {
        ByteArrayOutputStream outputStream = null;
        GZIPOutputStream gzipOutputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            gzipOutputStream = new GZIPOutputStream(outputStream);
            gzipOutputStream.write(bytes);
            gzipOutputStream.flush();
            gzipOutputStream.close();
            return outputStream.toByteArray();
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
            return null;
        }
    }

    public static String ungzip(byte[] bytes) {
        ByteArrayInputStream inputStream = null;
        GZIPInputStream gzipInputStream = null;
        try {
            String line;
            inputStream = new ByteArrayInputStream(bytes);
            gzipInputStream = new GZIPInputStream(inputStream);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)gzipInputStream, "utf-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuilder builder = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                builder.append(line);
            }
            bufferedReader.close();
            return builder.toString();
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
            return null;
        }
    }
}

