/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.api.bo.reqresult;

import cn.com.duiba.api.bo.reqresult.Result;

public final class ResultBuilder {
    private static final String DEFAULT_FAIL_CODE = "1000000000";
    private static final String DEFAULT_SUCCESS_CODE = "0000000000";

    private ResultBuilder() {
    }

    public static <T> Result<T> fail(String code, String desc) {
        Result result = new Result();
        result.setTimestamp(System.currentTimeMillis());
        result.setSuccess(false);
        result.setCode(code);
        result.setDesc(desc);
        return result;
    }

    public static <T> Result<T> fail(String desc) {
        return ResultBuilder.fail(DEFAULT_FAIL_CODE, desc);
    }

    public static <T> Result<T> fail(String code, String desc, T data) {
        Result<T> result = new Result<T>();
        result.setTimestamp(System.currentTimeMillis());
        result.setSuccess(false);
        result.setCode(code);
        result.setDesc(desc);
        result.setData(data);
        return result;
    }

    public static <T> Result<T> fail(String desc, T data) {
        return ResultBuilder.fail(DEFAULT_FAIL_CODE, desc, data);
    }

    public static <T> Result<T> success(String code, T data) {
        Result<T> result = new Result<T>();
        result.setTimestamp(System.currentTimeMillis());
        result.setSuccess(true);
        result.setCode(code);
        result.setData(data);
        result.setDesc("OK");
        return result;
    }

    public static <T> Result<T> success(T data) {
        return ResultBuilder.success(DEFAULT_SUCCESS_CODE, data);
    }

    public static <T> Result<T> success() {
        return ResultBuilder.success(DEFAULT_SUCCESS_CODE, null);
    }
}

