package cn.com.duiba.api.enums;

import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;

import java.util.Map;

/**
 * @Author: lufeng
 * @Description: 业务主体枚举类
 * @Date: Created in 2019/8/14
 */
public enum SubjectTypeEnum {

    DUIBA("1","兑吧"),
    DUIA("2","兑啊"),
    DUIJIE("3","兑捷");

    private String type;

    private String desc;

    private static Map<String, String> typeMap = Maps.newHashMap();

    SubjectTypeEnum(String type,String desc){
        this.type = type;
        this.desc = desc;
    }

    static{
        for(SubjectTypeEnum typeClass : SubjectTypeEnum.values()){
            typeMap.put(typeClass.getType(), typeClass.getDesc());
        }
    }

    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByType(String type) {
        if (StringUtils.isBlank(type)) {
            return null;
        }
        return typeMap.get(type);
    }


}
