package cn.com.duiba.api.enums.hbase;

import org.apache.commons.lang3.StringUtils;

public enum DeveloperCenterHBaseKeyEnum {
    K001("问券参与人数"),
    ;

    private String desc;

    DeveloperCenterHBaseKeyEnum(String desc) {
        this.desc = desc;
    }

    /**
     * 定制活动web: htool-web HBase key space
     */
    private static final String SPACE = "DEVELOP_CENRER";

    public String getDesc() {
        return desc;
    }

    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return SPACE + "_" + super.toString() + "_";
    }

    /**
     * 拼接字符串
     * 1.入参不能为null, 不然会变成__ 两个下划线
     *
     * @param strs
     * @return
     */
    public String join(Object... strs) {
        return toString().concat(StringUtils.join(strs, "_"));
    }
}
