package cn.com.duiba.api.enums.hbase;

import org.apache.commons.lang3.StringUtils;

/**
 * <p>签到活动hbase-key</p>
 * <p>created by Xuwei on 2021/3/8<p>
 **/
public enum SignWebHBaseKeyEnum {
    H001("签到组件-用户提醒")
    ;

    private static final String SPACE = "SIGNWH";

    private String desc;

    SignWebHBaseKeyEnum(String desc) {
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return SPACE + "_" + super.toString() + "_";
    }

    /**
     * 拼接字符串
     * 1.入参不能为null, 不然会变成__ 两个下划线
     *
     * @param strs
     * @return
     */
    public String join(Object... strs) {
        return toString().concat(StringUtils.join(strs,"_"));
    }
}
