package cn.com.duiba.api.enums.phapp;

import cn.com.duiba.api.enums.RedisKeySpace;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * @program: trade-access-web
 * @description: 招行前置机业务请求状态结果
 * @author: Simba
 * @create: 2019-01-24 17:31
 **/
public enum PhAppSerialNoEnum {

    JUDGE_MEMBER(RedisKeySpace.K5002.toString(), 90000000L, "注册会员标识"),
    MEMBER_INFO(RedisKeySpace.K5003.toString(), 80000000L, "获取用户信息"),
    LIST_ADDRESS(RedisKeySpace.K5004.toString(), 70000000L, "获取用户收货地址"),
    NEW_ADDRESS(RedisKeySpace.K5005.toString(), 60000000L, "新增收货地址"),
    SMS_CODE(RedisKeySpace.K5006.toString(), 50000000L, "发送验证码"),
    REGISTER(RedisKeySpace.K5007.toString(), 40000000L, "注册"),
    VIRTUAL(RedisKeySpace.K5009.toString(), 20000000L, "第三方领券"),
    BACKUPS(RedisKeySpace.K5008.toString(), 100000000L, "浦惠app备用流水号"),
    ;

    public static final ImmutableMap<String, PhAppSerialNoEnum> SERIAL_NO__MAP;

    static {
        Map<String, PhAppSerialNoEnum> code = Maps.newHashMap();
        for (PhAppSerialNoEnum cmbTransferRequestEnum : values()) {
            code.put(cmbTransferRequestEnum.getKey(), cmbTransferRequestEnum);
        }
        SERIAL_NO__MAP = ImmutableMap.copyOf(code);
    }


    private String key;
    private Long startSerialNo;
    private String desc;

    PhAppSerialNoEnum(String key, Long startSerialNo, String desc) {
        this.key = key;
        this.startSerialNo = startSerialNo;
        this.desc = desc;
    }

    public String getKey() {
        return key;
    }

    public Long getStartSerialNo() {
        return startSerialNo;
    }

    public String getDesc() {
        return desc;
    }}

