/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.api.tools;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class BizToolJarVersionUtils {
    private BizToolJarVersionUtils() {
    }

    public static Boolean isJarVersionEqualOrGreaterThan(String currentVersion, String baseVersion) {
        if (StringUtils.isBlank((String)currentVersion) || StringUtils.isBlank((String)baseVersion)) {
            return null;
        }
        Integer[] currentVersionArr = BizToolJarVersionUtils.normalization(currentVersion);
        if (currentVersionArr == null) {
            return null;
        }
        Integer[] baseVersionArr = BizToolJarVersionUtils.normalization(baseVersion);
        if (baseVersionArr == null) {
            return null;
        }
        int minLen = Math.min(currentVersionArr.length, baseVersionArr.length);
        for (int i = 0; i < minLen; ++i) {
            if (currentVersionArr[i] > baseVersionArr[i]) {
                return true;
            }
            if (currentVersionArr[i] >= baseVersionArr[i]) continue;
            return false;
        }
        return currentVersionArr.length >= baseVersionArr.length;
    }

    private static Integer[] normalization(String v) {
        String nv = v;
        if (v.contains("-")) {
            nv = v.substring(0, v.indexOf(45));
        }
        String[] vs = StringUtils.split((String)nv, (char)'.');
        ArrayList<Integer> vsList = new ArrayList<Integer>();
        for (int i = 0; i < vs.length; ++i) {
            String v1 = vs[i];
            if (BizToolJarVersionUtils.isInteger(v1)) {
                vsList.add(Integer.parseInt(v1));
                continue;
            }
            if (i >= vs.length - 1) continue;
            return null;
        }
        return vsList.toArray(new Integer[vsList.size()]);
    }

    private static boolean isInteger(String str) {
        if (StringUtils.isBlank((String)str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }
}

