/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.duiba.base.service.api.id.generator;

import cn.com.duiba.duiba.base.service.api.id.generator.bean.IdGeneratorKey;
import cn.com.duiba.duiba.base.service.api.id.generator.configuration.IdGeneratorProperties;
import cn.com.duiba.duiba.base.service.api.id.generator.configuration.Scene;
import cn.com.duiba.duiba.base.service.api.id.generator.exception.IdGeneratorException;
import cn.com.duiba.duiba.base.service.api.id.generator.service.IdGeneratorCache;
import cn.com.duiba.wolf.redis.RedisAtomicClient;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.scheduling.annotation.Scheduled;

public class IdGeneratorClient {
    @Resource(name="redisTemplate")
    private RedisAtomicClient redisAtomicClient;
    @Resource
    private IdGeneratorProperties idGeneratorProperties;
    private final LoadingCache<IdGeneratorKey, IdGeneratorCache> cache = Caffeine.newBuilder().build((CacheLoader)new CacheLoader<IdGeneratorKey, IdGeneratorCache>(){

        public IdGeneratorCache load(@NonNull IdGeneratorKey key) {
            IdGeneratorCache idGeneratorCache = new IdGeneratorCache(IdGeneratorClient.this.redisAtomicClient, IdGeneratorClient.this.idGeneratorProperties);
            idGeneratorCache.setScene(IdGeneratorClient.this.idGeneratorProperties.getScenes().get(key.getSceneKey()));
            idGeneratorCache.setKey(key);
            idGeneratorCache.init();
            return idGeneratorCache;
        }
    });

    public Long idGenerator(String sceneKey) {
        return this.generator(sceneKey, new Date());
    }

    private Long generator(String sceneKey, Date time) {
        Scene scene = this.idGeneratorProperties.getScenes().get(sceneKey);
        if (Objects.isNull(scene)) {
            throw new IdGeneratorException("\u53d1\u53f7\u573a\u666f[" + sceneKey + "]\u672a\u914d\u7f6e");
        }
        String formatTime = scene.getTimeLevel().formatTime(time);
        IdGeneratorKey key = new IdGeneratorKey();
        key.setSceneKey(sceneKey);
        key.setTime(formatTime);
        IdGeneratorCache idGeneratorCache = (IdGeneratorCache)this.cache.get((Object)key);
        return Objects.requireNonNull(idGeneratorCache).get();
    }

    @Scheduled(cron="0 0 1/1 * * ?")
    public void scanCache() {
        HashSet keys = Sets.newHashSet();
        for (Map.Entry entry : this.cache.asMap().entrySet()) {
            IdGeneratorCache idGeneratorCache = (IdGeneratorCache)entry.getValue();
            if (!idGeneratorCache.isInvalidate().booleanValue()) continue;
            keys.add((IdGeneratorKey)entry.getKey());
        }
        for (IdGeneratorKey key : keys) {
            this.cache.invalidate((Object)key);
        }
    }
}

