/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.duiba.base.service.api.mybatis.plugins.auto;

import cn.com.duiba.duiba.base.service.api.mybatis.plugins.DbEncryptionPlugin;
import cn.com.duiba.duiba.base.service.api.mybatis.plugins.config.QyDbEncryptProperties;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import com.alibaba.fastjson.JSON;
import java.util.Properties;
import javax.annotation.Resource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@EnableConfigurationProperties(value={QyDbEncryptProperties.class})
public class QyMybatisBeanPostProcessor
implements SpecifiedBeanPostProcessor<Object> {
    @Resource
    private QyDbEncryptProperties qyDbEncryptProperties;

    public int getOrder() {
        return -1;
    }

    public Class<Object> getBeanType() {
        return Object.class;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        SqlSessionFactory s = null;
        if (bean instanceof SqlSessionFactory) {
            s = (SqlSessionFactory)bean;
        }
        if (bean instanceof SqlSessionTemplate) {
            s = ((SqlSessionTemplate)bean).getSqlSessionFactory();
        }
        if (s == null) {
            return bean;
        }
        this.addInterceptor(s);
        return bean;
    }

    private void addInterceptor(SqlSessionFactory s) {
        DbEncryptionPlugin plugin = new DbEncryptionPlugin();
        Properties properties = new Properties();
        properties.put("secretMap", JSON.toJSONString(this.qyDbEncryptProperties.getSecrets()));
        properties.put("tables", JSON.toJSONString(this.qyDbEncryptProperties.getTables()));
        plugin.setProperties(properties);
        s.getConfiguration().addInterceptor((Interceptor)plugin);
    }
}

