/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.duiba.base.service.api.duibaboot.oss.template.metadata;

import com.aliyun.oss.model.ObjectMetadata;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectMetadataHelper {
    private static final Logger log = LoggerFactory.getLogger(ObjectMetadataHelper.class);
    public static final String USER_DATE_PREFIX = "x-oss-meta-";
    private ObjectMetadata objectMetadata;

    public static ObjectMetadataHelper create() {
        ObjectMetadataHelper builder = new ObjectMetadataHelper();
        builder.objectMetadata = new ObjectMetadata();
        return builder;
    }

    public ObjectMetadataHelper setContentType(String contentType) {
        this.objectMetadata.setContentType(contentType);
        return this;
    }

    public ObjectMetadataHelper setContentEncoding(String encoding) {
        this.objectMetadata.setContentEncoding(encoding);
        return this;
    }

    public ObjectMetadataHelper setAsDownloadFile(String fileName) {
        if (StringUtils.isBlank((String)fileName)) {
            throw new UnsupportedOperationException("\u5f3a\u5236\u4e0b\u8f7d\u6a21\u5f0f\uff0c\u8bf7\u6307\u5b9a\u6587\u4ef6\u540d\uff01");
        }
        this.objectMetadata.setContentDisposition("attachment; filename=\"" + fileName + "\"");
        return this;
    }

    public ObjectMetadataHelper setContentLength(Long contentLength) {
        this.objectMetadata.setContentLength(contentLength.longValue());
        return this;
    }

    public ObjectMetadataHelper setExpirationTime(Date expirationTime) {
        this.objectMetadata.setExpirationTime(expirationTime);
        return this;
    }

    public ObjectMetadataHelper addUserDate(String key, String value) {
        if (StringUtils.isBlank((String)key) || StringUtils.isBlank((String)value)) {
            throw new UnsupportedOperationException("\u81ea\u5b9a\u4e49\u5c5e\u6027\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
        if (!StringUtils.startsWith((String)key, (String)USER_DATE_PREFIX)) {
            key = USER_DATE_PREFIX + key;
        }
        this.objectMetadata.getUserMetadata().put(key, value);
        return this;
    }

    public ObjectMetadataHelper forbidOverWrite() {
        this.objectMetadata.setHeader("x-oss-forbid-overwrite", (Object)true);
        return this;
    }

    public ObjectMetadataHelper canOverWrite() {
        this.objectMetadata.addUserMetadata("canOverWrite", "true");
        return this;
    }

    public ObjectMetadata getInstance() {
        if (this.objectMetadata.getContentLength() == 0L) {
            log.info("\u6211\u4eec\u63a8\u8350\u5143\u7a7a\u95f4\u6570\u636e\u5bf9\u8c61\u542b\u6709\u6587\u4ef6\u5927\u5c0f\uff0c\u4ee5\u4fdd\u8bc1\u6587\u4ef6\u7684\u5b8c\u6574\u6027");
        }
        return this.objectMetadata;
    }
}

