/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.duiba.base.service.api.mybatis.plugins.handler.encrypt.impl;

import cn.com.duiba.duiba.base.service.api.mybatis.plugins.enums.EncryptorEnum;
import cn.com.duiba.duiba.base.service.api.mybatis.plugins.handler.encrypt.EncryptionDecryptionAdapter;
import cn.com.duiba.duiba.base.service.api.mybatis.plugins.handler.encrypt.EncryptionDecryptionHandler;
import cn.com.duiba.duiba.base.service.api.mybatis.plugins.utils.SM4Util;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={SqlSessionTemplate.class, SqlSessionFactoryBean.class, SqlSessionFactory.class})
public class Sm4Handler
implements EncryptionDecryptionHandler {
    @Override
    public EncryptorEnum encryptorEnum() {
        return EncryptorEnum.S;
    }

    @Override
    public String encrypt(String value, String secret) {
        return SM4Util.encryptEcb(secret, value);
    }

    @Override
    public String decrypt(String value, String secret) {
        return SM4Util.decryptEcb(secret, value);
    }

    public void afterPropertiesSet() throws Exception {
        EncryptionDecryptionAdapter.register(this);
    }
}

