package cn.com.duiba.duiba.base.service.api.id.generator.configuration;

import cn.com.duiba.duiba.base.service.api.id.generator.IdGeneratorClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.scheduling.annotation.EnableScheduling;

/**
 * @author lizhi
 * @date 2024/12/30 13:48
 */
@EnableScheduling
@Configuration
@EnableConfigurationProperties(IdGeneratorProperties.class)
@ConditionalOnClass(RedisOperations.class)
public class IdGeneratorConfiguration {
    
    @Bean
    @DependsOn("redisTemplate")
    @Primary
    public IdGeneratorClient idGeneratorClient(){
        return new IdGeneratorClient();
    }
    
}
