package cn.com.duiba.duiba.base.service.api.mybatis.plugins.handler.encrypt;

import cn.com.duiba.duiba.base.service.api.mybatis.plugins.enums.EncryptorEnum;
import org.springframework.beans.factory.InitializingBean;

/**
 * @author lizhi
 * @date 2024/9/25 18:23
 */
public interface EncryptionDecryptionHandler extends InitializingBean {

    /**
     * 加密方式
     * @return 加密方式
     */
    EncryptorEnum encryptorEnum();

    /**
     * 加密字符串
     * @param value 字符串
     * @param secret 密钥
     * @return 加密后的字符串
     */
    String encrypt(String value, String secret);

    /**
     * 解密字符串
     * @param value 字符串
     * @param secret 密钥
     * @return 解密后的字符串
     */
    String decrypt(String value, String secret);
}
