package cn.com.duiba.duiba.base.service.api.duibaboot.oss.template.support;

import cn.com.duiba.duiba.base.service.api.duibaboot.oss.template.operation.MultipartTask;
import com.aliyun.oss.model.ObjectMetadata;
import lombok.extern.slf4j.Slf4j;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;

/**
 * @author dugq
 * @date 2021/7/28 4:23 下午
 */
@Slf4j
public class MultiUploadSupport {

    private static final int partSize = 2 * 1024 * 1024;

    public static boolean simpleMultipartUpload(MultipartTask multipartTask, InputStream inputStream, String objectName, ObjectMetadata meta) throws IOException {
        final boolean createResult = multipartTask.startMultipartPartUpload(objectName, meta);
        if (!createResult){
            return false;
        }
        final List<byte[]> partList = splitStream(inputStream);
        for (int i = 0, partListSize = partList.size(); i < partListSize; i++) {
            final boolean result = uploadMultipart(multipartTask, i, partList.get(i));
            if (!result){
                return false;
            }
        }
        return true;
    }

    private static boolean uploadMultipart(MultipartTask multipartTask, int i, byte[] bytes) {
        boolean result = multipartTask.multipartPartUpload(new ByteArrayInputStream(bytes), (long) bytes.length, i);
        if (!result){
            result = multipartTask.multipartPartUpload(new ByteArrayInputStream(bytes), (long) bytes.length, i);
            return result;
        }
        return true;
    }


    private static List<byte[]> splitStream(InputStream inputStream) throws IOException {
        List<byte[]> linkedList = new LinkedList<>();
        while (true){
            byte[] buffer = new byte[partSize];
            final int read = inputStream.read(buffer);
            if (read==-1){
                return linkedList;
            }
            linkedList.add(buffer);
        }
    }
}
