package cn.com.duiba.galaxy.api.model.dto;

import cn.com.duiba.galaxy.api.model.dto.jsonfield.BaseAttributesJsonDto;
import cn.com.duiba.galaxy.api.model.dto.jsonfield.PlayAttributesJsonDto;
import cn.com.duiba.galaxy.api.model.dto.jsonfield.ViewAttributesJsonDto;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * 项目DTO
 *
 * @author fangxiaorun
 * @date 2022/10/18
 */
@Getter
@Setter
public class ProjectDto implements Serializable {

    private static final long serialVersionUID = -44961641526572499L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 玩法配置数据
     */
    private PlayAttributesJsonDto playAttributes;

    /**
     * 界面配置数据
     */
    private ViewAttributesJsonDto viewAttributes;

    /**
     * 基础配置数据
     */
    private BaseAttributesJsonDto baseAttributes;

    /**
     * 0:创建，1:上架中，2:下架，3:终止
     */
    private Integer state;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 最后操作人
     */
    private String operator;

    /**
     * 关联原型ID
     */
    private Long prototypeId;

    /**
     * 来源 0活动平台,1积分商城
     */
    private Integer source;

    /**
     * 是否是正式项目 0非正式,1正式
     */
    private Integer prod;

    /**
     * 定向应用ID
     */
    private Long appId;

    /**
     * 活动开始时间
     */
    private Date startTime;

    /**
     * 活动结束时间
     */
    private Date endTime;

    /**
     * OpenBs 0关闭 1开启
     */
    private Integer openbs;
}
