package cn.com.duiba.galaxy.api.model.dto.jsonfield;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 奖项json
 *
 * @author fangxiaorun
 * @date 2022/10/18
 */
@Getter
@Setter
public class OptionJsonDto implements Serializable {

    private static final long serialVersionUID = 2570554630986332102L;

    /**
     * id
     */
    private String id;
    /**
     * 名称
     */
    private String name;
    /**
     * 用户限制类型
     */
    private String userLimitType;
    /**
     * 图标
     */
    private String icon;

    /**
     * 发奖限制类型
     */
    private String awardLimitType;

    /**
     * 奖品id
     */
    private String prizeId;
    /**
     * 奖品信息
     */
    private PrizeJsonDto award;
    /**
     * 奖项位置
     */
    private Integer pos;
    /**
     * 概率
     */
    private String rate;
    /**
     * 使用库存
     */
    private Integer usedStock;

    /**
     * 总库存
     */
    private Long totalStock;

    /**
     * 用户限制
     */
    private Long userLimit;
    /**
     * 奖限制
     */
    private Long awardLimit;
    /**
     * 保底人数
     */
    private Long atleastTimes;

    /**
     * 是否在首页展示 0 不展示 ， 1展示
     */
    private Integer showIndexType;

    /**
     * 单次发放个数(仅道具)
     */
    private Long sendCount;
}
