package cn.com.duiba.galaxy.api.model.param;

import cn.com.duiba.galaxy.api.model.param.jsonfield.BaseAttributesJsonParam;
import cn.com.duiba.galaxy.api.model.param.jsonfield.PlayAttributesJsonParam;
import cn.com.duiba.galaxy.api.model.param.jsonfield.ViewAttributesJsonParam;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * 项目创建或更新参数
 * 注：仅供积分商城使用
 *
 * @author fangxiaorun
 * @date 2022/10/17
 */
@Getter
@Setter
public class ProjectCreateOrUpdateParam implements Serializable {

    private static final long serialVersionUID = 7761141344880451353L;

    /**
     * appId
     */
    private Long appId;

    /**
     * 模版ID
     */
    private Long templateId;

    /**
     * 项目id
     */
    private Long id;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 玩法属性
     */
    private PlayAttributesJsonParam playAttributes;

    /**
     * 界面属性
     */
    private ViewAttributesJsonParam viewAttributes;

    /**
     * 基础属性
     */
    private BaseAttributesJsonParam baseAttributes;
}