package cn.com.duiba.galaxy.api.model.param.jsonfield;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 多个奖项限制json参数
 *
 * @author fangxiaorun
 * @date 2022/10/17
 */
@Getter
@Setter
public class MultipleOptionLimitJsonParam implements Serializable {

    private static final long serialVersionUID = -1664887004141356241L;

    /**
     * 限制次数
     */
    private Long limitTimes;

    /**
     * 自定义天数
     */
    private Integer customDays;

    /**
     * 限制类型 1永久 2日 3周 4月 5自定义
     */
    private Integer limitType;

    /**
     * 限制奖项id列表
     */
    private List<String> limitOptionIds;
}
