package cn.com.duiba.galaxy.api.model.param.jsonfield;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 奖项json参数
 *
 * @author fangxiaorun
 * @Date 2022/10/15 17:07
 */
@Getter
@Setter
public class OptionJsonParam implements Serializable {

    private static final long serialVersionUID = -1458429323665526349L;

    /**
     * 奖项id
     */
    private String id;

    /**
     * 奖项名称
     */
    private String name;

    /**
     * 图标
     */
    private String icon;

    /**
     * 总库存
     */
    private Long totalStock;

    /**
     * 概率
     */
    private String rate;

    /**
     * 用户中奖限制次数
     */
    private Long userLimit;

    /**
     * 用户中奖限制类型(日，周，月，永久)
     */
    private Integer userLimitType;

    /**
     * 发奖限制
     */
    private Long awardLimit;

    /**
     * 发奖限制类型(日，周，月，永久)
     */
    private Integer awardLimitType;

    /**
     * 奖品id
     */
    private String prizeId;

    /**
     * 奖品信息
     */
    private PrizeJsonParam award;

    /**
     * 奖项位置
     */
    private Integer pos;

    /**
     * 已使用库存
     */
    private Long usedStock;

    /**
     * 保底次数(有多少次抽奖行为才会中奖)
     */
    private Long atleastTimes;

    /**
     * 是否在首页展示 0 不展示 ， 1展示
     */
    private Integer showIndexType;

    /**
     * 单次发放个数(仅道具)
     */
    private Long sendCount;
}
