package cn.com.duiba.galaxy.api.model.param.jsonfield;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 奖品json参数
 *
 * @author fangxiaorun
 * @date 2022/10/17
 */
@Getter
@Setter
public class PrizeJsonParam implements Serializable {

    private static final long serialVersionUID = 3516696696456753936L;

    /**
     * 运营是否可编辑 true 可编辑
     */
    private Boolean editable;

    /**
     * 图标 未获得奖品图
     */
    private String icon;

    /**
     * 图标2（已获得奖品图）
     */
    private String icon2;

    /**
     * 第三方商品类型(coupon等类型)
     */
    private String refType;

    /**
     * 奖品id
     */
    private String id;

    /**
     * 奖品名称
     */
    private String name;

    /**
     * 第三方商品ID
     */
    private Integer refId;

    /**
     * 奖品类型
     *
     * @see cn.com.duiba.galaxy.console.enums.PrizeTypeEnum
     */
    private Integer type;

    /**
     * 子类型(针对道具永久，每日，每周，每月的类型)
     */
    private Integer subType;
}
