package cn.com.duiba.galaxy.api.model.param.jsonfield;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 出奖策略json参数
 *
 * @author fangxiaorun
 * @date 2022/10/17
 */
@Getter
@Setter
public class StrategyJsonParam implements Serializable {

    private static final long serialVersionUID = 6807063861433366435L;

    /**
     * 发奖规则id
     */
    private String id;

    /**
     * 发奖规则类型（1概率出奖，2百分比中奖）
     */
    private Integer type;

    /**
     * 发奖规则名称
     */
    private String name;

    /**
     * 奖项列表
     */
    private List<OptionJsonParam> options;

    /**
     * 多个奖项限制
     */
    private MultipleOptionLimitJsonParam multipleOptionLimit;

    /**
     * 用户层奖品
     */
    private UserLayerPrizeJsonParam userLayerPrize;
}
