package cn.com.duiba.galaxy.api.model.param.jsonfield;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 用户层奖品json参数
 *
 * @author fangxiaorun
 * @date 2022/10/17
 */
@Getter
@Setter
public class UserLayerPrizeJsonParam implements Serializable {

    private static final long serialVersionUID = -3078173993743957046L;

    /**
     * 已选择的出奖类型(diffPrizes区分奖池出奖或者randomPrizes区分概率出奖)
     */
    private String selectedType;

    /**
     * 区分奖池出奖
     */
    private List<DiffPrizeJsonParam> diffPrizes;

    /**
     * 区分概率出奖
     */
    private Object randomPrizes;
}
