package cn.com.duiba.galaxy.api.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.galaxy.api.model.dto.EnumDto;

import java.util.List;

/**
 * 管理后台通用服务
 * 注：仅供积分商城调用
 *
 * @author fangxiaorun
 * @date 2022/10/28
 */
@AdvancedFeignClient
public interface RemoteCommonBackendService {

    /**
     * 根据枚举类名获取枚举常量
     * <p>
     * 传参返回对应枚举常量，不传参则返回管理后台所有枚举类常量，以下是目前已有枚举：
     * <p>PrototypeTypeEnum    原型类型枚举
     * <p>TemplateTypeEnum     模版类型枚举
     * <p>TemplateSyncStateEnum 模版同步状态枚举
     * <p>PlaywayTypeEnum      玩法类型枚举
     * <p>ProjectStateEnum     项目状态枚举
     * <p>PrototypeStateEnum   原型状态枚举
     *
     * @param name 名称
     * @return {@link List}<{@link EnumDto}>
     */
    List<EnumDto> getEnumByName(String name) throws BizException;
}
