package cn.com.duiba.galaxy.api.model.dto;

import cn.com.duiba.galaxy.api.model.dto.jsonfield.ComponentDto;
import cn.com.duiba.galaxy.api.model.dto.jsonfield.PlayAttributesJsonDto;
import cn.com.duiba.galaxy.api.model.dto.jsonfield.ViewAttributesJsonDto;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 原型DTO
 *
 * @author fangxiaorun
 * @date 2022/09/26
 */
@Getter
@Setter
public class PrototypeDto implements Serializable {

    private static final long serialVersionUID = -6085382577943929988L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 原型名称
     */
    private String prototypeName;

    /**
     * 原型类型 1定制,2模版
     */
    private Integer prototypeType;

    /**
     * 0:待编辑，1:未启用，2:启用
     */
    private Integer state;

    /**
     * 用途类型
     */
    private Integer prototypeUseType;

    /**
     * 玩法选型
     */
    private Integer playwayType;

    /**
     * 玩法配置数据
     */
    private PlayAttributesJsonDto playAttributes;

    /**
     * 界面配置数据
     */
    private ViewAttributesJsonDto viewAttributes;

    /**
     * 组件
     */
    private List<ComponentDto> components;
    /**
     * sps
     */
    private List<SpDto> sps;
    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 最后操作人
     */
    private String operator;

    /**
     * 代码提交版本号
     */
    private String commitId;
}




