package cn.com.duiba.galaxy.api.model.param.jsonfield;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 自定义配置json参数
 *
 * @author fangxiaorun
 * @date 2022/10/17
 */
@Getter
@Setter
public class CustomConfigJsonParam implements Serializable {

    private static final long serialVersionUID = -6811690263661117475L;

    /**
     * 配置项名称
     */
    private String name;

    /**
     * 配置项变量
     */
    private String variable;

    /**
     * 校验
     */
    private String valid;

    /**
     * 类型
     *
     * @see cn.com.duiba.galaxy.console.enums.CustomConfigVariableTypeEnum
     */
    private Integer type;

    /**
     * 配置类型(前端配置项，后端配置项，运营配置项)
     *
     * @see cn.com.duiba.galaxy.console.enums.ConfigTypeEnum
     */
    private Integer configType;

    /**
     * 提示
     */
    private String tips;

    /**
     * 值
     */
    private String value;

    /**
     * 描述(type为JSONArray时必填)
     */
    private String desc;


}
