package cn.com.duiba.galaxy.api.model.param.jsonfield;


import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * 活动预告页配置JSON
 *
 * @author fangxiaorun
 * @date 2023/02/16
 */
@Getter
@Setter
public class UpcomingEventsConfigJsonParam implements Serializable {

    private static final long serialVersionUID = 3238496900872398376L;

    /**
     * 开关状态，0 关闭，1 开启
     */
    private Integer status;
    /**
     * 预告页开启时间
     */
    private Date openTime;
    /**
     * 预告页关闭时间
     */
    private Date closeTime;
    /**
     * 1 展示时间；2 展示自定义文案
     */
    private Integer showType;
    /**
     * 预告页面上展示的时间
     */
    private Date showTime;
    /**
     * 预告页面上展示的自定义文案
     */
    private String showDesc;
    /**
     * 口令码
     */
    private String passcode;
    /**
     * 口令码使用人数上限
     */
    private Long useLimit;
    /**
     * 预告页标题
     */
    private String title;
}
